##                                                                                                ##
## Description                                                                                    ##
##                                                                                                ##
'''
This simple bench is intended to test the NX_SPW_BANK component instantiation.

It is intended to be tested on NX1H35 v2 board.
'''
##                                                                                                ##
## End of description                                                                             ##
##                                                                                                ##



import sys
import subprocess

from os import path
from os import symlink

from nanoxmap import *


baseDir = path.dirname(path.realpath(__file__))

sys.path.append(baseDir)

p = createProject(baseDir)

p.setVariantName('NG-MEDIUM')

p.setTopCellName('test')

p.addFile('src/test.vhd')
p.addIP('IP_SPW_BANK')

p.setOptions({'MappingEffort': 'Low', 'UseNxLibrary': 'Yes'})


pads = {
  'SW[0]'    : {'location': 'IOB10_D09P', 'type': 'LVCMOS_1.8V_2mA'} # SW 1
, 'SW[1]'    : {'location': 'IOB10_D03P', 'type': 'LVCMOS_1.8V_2mA'} # SW 2
, 'SW[2]'    : {'location': 'IOB10_D03N', 'type': 'LVCMOS_1.8V_2mA'} # SW 3
, 'SW[3]'    : {'location': 'IOB10_D04P', 'type': 'LVCMOS_1.8V_2mA'} # SW 4
, 'SW[4]'    : {'location': 'IOB10_D09N', 'type': 'LVCMOS_1.8V_2mA'} # SW 5
, 'SW[5]'    : {'location': 'IOB10_D04N', 'type': 'LVCMOS_1.8V_2mA'} # SW 6
, 'WORD6[0]' : {'location': 'IOB0_D01P',  'type': 'LVCMOS_3.3V_2mA'} # LED1
, 'WORD6[1]' : {'location': 'IOB0_D03N',  'type': 'LVCMOS_3.3V_2mA'} # LED2
, 'WORD6[2]' : {'location': 'IOB0_D03P',  'type': 'LVCMOS_3.3V_2mA'} # LED3
, 'WORD6[3]' : {'location': 'IOB1_D05N',  'type': 'LVCMOS_3.3V_2mA'} # LED4
, 'WORD6[4]' : {'location': 'IOB1_D05P',  'type': 'LVCMOS_3.3V_2mA'} # LED5
, 'WORD6[5]' : {'location': 'IOB1_D06N',  'type': 'LVCMOS_3.3V_2mA'} # LED6
, 'ckOut'    : {'location': 'IOB0_D04N',  'type': 'LVCMOS_3.3V_2mA'} # BANK0.TP1.10
, 'RESET'    : {'location': 'IOB10_D12P', 'type': 'LVCMOS_1.8V_2mA'} # SW 9
}

p.addPads(pads)

p.save('native.nxm')

if not p.synthesize():
    p.destroy()

    sys.exit(1)

p.save('synthesized.vhd')

if not p.place():
    p.destroy()

    sys.exit(1)

p.save('placed.vhd')

if not p.route():
    p.destroy()

    sys.exit(1)

p.save('routed.vhd')

p.generateBitstream('test.nxb')

p.destroy()

printText('Design successfully generated')

