library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library NX;
use NX.nxPackage.all;

entity test is
port(
    RESET: in  std_logic;
    DI    : in  std_logic;
    SI    : in  std_logic;
    DO    : out std_logic;
    SO    : out std_logic;
    rxOut : out std_logic;
    txOut : out std_logic;
    SW    : in  std_logic_vector(5 downto 0);
    WORD  : out std_logic_vector(10 downto 0);
    WORD6 : out std_logic_vector(5 downto 0)
);
end entity;

architecture rtl of test is

component IP_SPW_BANK is
generic (
    dataSize  : integer;
    bank      : string;
    voltage   : string;
    reference : string
);
port (
    DO1    : out std_logic;                                         -- SPW1 D out
    SO1    : out std_logic;                                         -- SPW1 S out
    DI1    : in  std_logic := '0';                                  -- SPW1 D in
    SI1    : in  std_logic := '0';                                  -- SPW1 S in

    RXRST1 : in  std_logic := '0';                                  -- SPW1 RX reset
    RXO1   : out std_logic_vector(19 downto 0);                     -- SPW1 RX data out (2x10 bits)
    RXSCK1 : out std_logic;                                         -- SPW1 RX slow clock

    TXRST1 : in  std_logic := '0';                                  -- SPW1 TX reset
    TXI1   : in  std_logic_vector(9 downto 0) := (others => '0');   -- SPW1 TX data in (10 bits)
    TXFCK1 : in  std_logic := '0';                                  -- SPW1 TX fast clock
    TXSCK1 : out std_logic;                                         -- SPW1 TX slow clock

    DO2    : out std_logic;                                         -- SPW2 D out
    SO2    : out std_logic;                                         -- SPW2 S out
    DI2    : in  std_logic := '0';                                  -- SPW2 D in
    SI2    : in  std_logic := '0';                                  -- SPW2 S in

    RXRST2 : in  std_logic := '0';                                  -- SPW2 RX reset
    RXO2   : out std_logic_vector(19 downto 0);                     -- SPW2 RX data out (2x10 bits)
    RXSCK2 : out std_logic;                                         -- SPW2 RX slow clock

    TXRST2 : in  std_logic := '0';                                  -- SPW2 TX reset
    TXI2   : in  std_logic_vector(9 downto 0) := (others => '0');   -- SPW2 TX data in (10 bits)
    TXFCK2 : in  std_logic := '0';                                  -- SPW2 TX fast clock
    TXSCK2 : out std_logic                                          -- SPW2 TX slow clock
);
end component;

signal sync  : std_logic;
signal fclk  : std_logic;
signal osc   : std_logic;

signal slowTXCK : std_logic;

signal data    : std_logic_vector( 9 downto 0);
signal dataOut : std_logic_vector(19 downto 0);

begin

txOut <= slowTXCK;

data <= "0000" & SW;

WORD  <= dataOut(19 downto 9);
WORD6 <= WORD(8 downto 3);

spw1 : IP_SPW_BANK
    generic map (
        dataSize  => 6
      , bank      => "IOB12"
      , voltage   => "2.5V"
      , reference => "VT"
    )
    port map (
        DO1    => DO
      , SO1    => SO
      , TXRST1 => NOT(RESET)
      , TXFCK1 => fclk
      , TXSCK1 => slowTXCK
      , TXFCK2 => fclk -- TODO should not connect
      , TXI1   => data
      , DI2    => DI
      , SI2    => SI
      , RXRST2 => NOT(RESET)
      , RXO2   => dataOut
      , RXSCK2 => rxOut
    );

--pll0 : NX_PLL
--    port map (
--        OSC => fclk
--    );

pll0 : NX_PLL
    port map (
        OSC => osc
    );

wfg_0 : NX_WFG            -- TXFCK ~ 200MHz
    generic map (
        mode        => '0'
    )
    port map (
        SI => sync
      , SO => sync
      , ZI => osc
      , ZO => fclk
    );

end rtl;
