import os
import sys

from nanoxmap import *

dir = str(os.path.dirname(os.path.realpath(__file__)))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('TOP_NX_SYSTOLIC_FIR')

project.addFiles(['src/DSP_SPLIT_GENERICS.vhd',
                  'src/NX_SYSTOLIC_FIR.vhd',
                  'src/NX_SYSTOLIC_CELL.vhd',
                  'src/TOP_NX_SYSTOLIC_FIR.vhd'])

project.setOptions({
   'UseNxLibrary': 'Yes',
   'MergeRegisterToPad': 'Always',
   'ManageUnconnectedSignals': 'Ground'
   })

#########################################################################
# Important note 1
#########################################################################
# 'ExportAsIPCore' saves the synthesized design before inserting pads
# in VHDL format. The resulting file can be then used as source in
# another project.
# No need to run "place" and "route"
options = {'coreName': 'SYSTOLIC_IP_Core'}

project.exportAsIPCore('src/SYSTOLIC_IP_Core.vhd', options)

project.createClock('getClockNet(CLK)', 'CLK', 5000, 0, 2500)

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

#########################################################################
# Important note 2
#########################################################################
# The '_synthese.vhd' file includes IO pads, unlike the file generated
# with "setOptions" => 'ExportAsIPCore': 'src/SYSTOLIC_IP_Core.vhd'
project.save('_synthese.vhd')

project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

##################################################################################################
# Simulation
##################################################################################################
simulator = project.createSimulator()

simulator.addTestBench('src/TB_TOP_NX_SYSTOLIC_FIR.vhd')
simulator.addTestBench('src/NX_SYSTOLIC_FIR.vhd')
simulator.setTestBenchTop('TB_TOP_NX_SYSTOLIC_FIR')
simulator.setWorkingDirectory('simu')
simulator.addWave('*')

simulator.launch('1us', True)

project.destroy()

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
