library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_arith.ALL;
use IEEE.STD_LOGIC_signed.ALL;

library nx;
use nx.nxPackage.all;
 
entity DSP_SPLIT_GENERICS is
generic (
-------------------------------------------------------------------------
-- Generic declaration to define the "raw_config0" (cfg_mode). Defines :
------------------------------------------------------------------------- 
   SIGNED_MODE : std_logic              := '1';
   PRE_ADDER_OP : std_logic             := '0';  -- '0' = Additon, '1' = Subraction
   MUX_A : std_logic                    := '0';  -- '0' = A input, '1' = CAI input
   MUX_B : std_logic                    := '0';  -- '0' = B input, '1' = CBI input
   MUX_P : std_logic                    := '0';  -- '0' for PRE_ADDER, '0' for B input
   MUX_X : std_logic_vector(1 downto 0) := "01"; -- Select X operand   "00" = C, "01" = CZI, "11" = SHFT(CZI) & C(11:0), "10" Select Z feedback 
   MUX_Y : std_logic                    := '0';  -- '0' Select MULT output, '1' for (B & A)
   MUX_CI : std_logic                   := '0';  -- Select fabric input (not cascade)
   MUX_Z : std_logic                    := '0';  -- Select ALU output (not ALU input operand coming from PR_Y
   
   Z_FEEDBACK_SHL12 : std_logic         := '0';  -- '0' for No shift, '1' for 12-bit left shift
   ENABLE_SATURATION : std_logic        := '0';  -- '0' for Disable, '1' for Enable
   SATURATION_RANK : std_logic_vector(5 downto 0) := "110110"; -- Weight of useful MSB on Z and CZO result (to define saturation and overflow) 
   
   ALU_DYNAMIC_OP : std_logic           := '0';  -- '0' for Static, '1' for Dynamic (D6 ... D1 is not used for dynamic operation)
   CO_SEL : std_logic                   := '0';  -- '0' for C0 = ALU(36), '1' for CO = ALU(48)   

-------------------------------------------------------------------------
-- Generic declaration to define the "raw_config1" (cfg_pipe_mux)
-------------------------------------------------------------------------
   PR_A_MUX : std_logic_vector(1 downto 0) := "01";         -- Number of pipe reg levels on A input
   PR_A_CASCADE_MUX : std_logic_vector(1 downto 0) := "10"; -- Number of pipe reg levels for CAO output
   PR_B_MUX : std_logic_vector(1 downto 0) := "01";         -- Number of pipe reg levels on B input
   PR_B_CASCADE_MUX : std_logic_vector(1 downto 0) := "10"; -- Number of pipe reg levels for CAO output
   
   PR_C_MUX : std_logic    := '0';       -- '0' for No pipe reg, '1' for 1 pipe reg
   PR_D_MUX : std_logic    := '1';       -- '0' for No pipe reg, '1' for 1 pipe reg
   PR_CI_MUX : std_logic   := '1';       -- '0' for No pipe reg, '1' for 1 pipe reg
   PR_P_MUX : std_logic    := '1';       -- '0' for No pipe reg, '1' for 1 pipe reg (Pre-adder)
   PR_X_MUX : std_logic    := '0';       -- '0' for No pipe reg, '1' for 1 pipe reg
   PR_Y_MUX : std_logic    := '1';       -- '0' for No pipe reg, '1' for 1 pipe reg
   
   PR_MULT_MUX : std_logic := '1';       -- No pipe reg  -- Register inside MULT
   PR_ALU_MUX : std_logic  := '0';       -- No pipe reg  -- Register inside ALU
   PR_Z_MUX : std_logic    := '1';       -- Registered output
   
   PR_CO_MUX : std_logic   := '0';       -- '0' for No pipe reg, '1' for 1 pipe reg
   PR_OV_MUX : std_logic   := '0';       -- '0' for No pipe reg, '1' for 1 pipe reg

-------------------------------------------------------------------------
-- Generic declaration to define the "raw_config2" (cfg_pipe_rst)
-------------------------------------------------------------------------
   ENABLE_PR_A_RST : std_logic    := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_B_RST : std_logic    := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_C_RST : std_logic    := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_D_RST : std_logic    := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_CI_RST : std_logic   := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_P_RST : std_logic    := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_X_RST : std_logic    := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_Y_RST : std_logic    := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_MULT_RST : std_logic := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_ALU_RST : std_logic  := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_Z_RST : std_logic    := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_CO_RST : std_logic   := '1';   -- '0' for Disable, '1' for Enable 
   ENABLE_PR_OV_RST : std_logic   := '1';   -- '0' for Disable, '1' for Enable 

-------------------------------------------------------------------------
-- Constants declaration to define the "cfg_pipe_rst" -- raw_config3(6 downto 0)
-------------------------------------------------------------------------
   ALU_OP : std_logic_vector(5 downto 0) := "000000";  -- Addition = "000000", Subtract = "001010"
   ALU_MUX : std_logic                   := '0'  -- '0' for Don't swap ALU operands, '1' for ALU Swap operands
    );
port(
   CK : IN  std_logic;
   R : IN  std_logic;
   RZ : IN  std_logic;
   WE : IN  std_logic;
   
   CI : IN  std_logic;  -- cy_i
   A : IN  std_logic_vector(23 downto 0);
   B : IN  std_logic_vector(17 downto 0);
   C : IN  std_logic_vector(35 downto 0);
   D : IN  std_logic_vector(17 downto 0);
   CAI : IN  std_logic_vector(17 downto 0);
   CBI : IN  std_logic_vector(17 downto 0);
   CZI : IN  std_logic_vector(55 downto 0);
   CCI : IN  std_logic;  -- ccy_i

   Z : out  std_logic_vector(55 downto 0);
   CO : OUT  std_logic;  -- cy_o
   CO36 : OUT  std_logic;  -- cy36_o
   CO48 : OUT  std_logic;  -- cy48_o
   OVF : OUT  std_logic;
   CAO : OUT  std_logic_vector(17 downto 0);
   CBO : OUT  std_logic_vector(17 downto 0);
   CZO : OUT  std_logic_vector(55 downto 0);
   CCO : OUT  std_logic  -- ccy_o
  );
end DSP_SPLIT_GENERICS;

architecture Behavioral of DSP_SPLIT_GENERICS is

-------------------------
-------------------------
-- translate_off
-- For simulation only
-------------------------
-------------------------
-------------------------
-- translate_on
-------------------------
-------------------------

----------------------------------------------------------
-- Internal signals to be mapped to the NX_DSP component
----------------------------------------------------------
signal A1	 : std_logic := '0';
signal A2	 : std_logic := '0';
signal A3	 : std_logic := '0';
signal A4	 : std_logic := '0';
signal A5	 : std_logic := '0';
signal A6	 : std_logic := '0';
signal A7	 : std_logic := '0';
signal A8	 : std_logic := '0';
signal A9	 : std_logic := '0';
signal A10	 : std_logic := '0';
signal A11	 : std_logic := '0';
signal A12	 : std_logic := '0';
signal A13	 : std_logic := '0';
signal A14	 : std_logic := '0';
signal A15	 : std_logic := '0';
signal A16	 : std_logic := '0';
signal A17	 : std_logic := '0';
signal A18	 : std_logic := '0';
signal A19	 : std_logic := '0';
signal A20	 : std_logic := '0';
signal A21	 : std_logic := '0';
signal A22	 : std_logic := '0';
signal A23	 : std_logic := '0';
signal A24	 : std_logic := '0';
         
signal B1	 : std_logic := '0';
signal B2	 : std_logic := '0';
signal B3	 : std_logic := '0';
signal B4	 : std_logic := '0';
signal B5	 : std_logic := '0';
signal B6	 : std_logic := '0';
signal B7	 : std_logic := '0';
signal B8	 : std_logic := '0';
signal B9	 : std_logic := '0';
signal B10	 : std_logic := '0';
signal B11	 : std_logic := '0';
signal B12	 : std_logic := '0';
signal B13	 : std_logic := '0';
signal B14	 : std_logic := '0';
signal B15	 : std_logic := '0';
signal B16	 : std_logic := '0';
signal B17	 : std_logic := '0';
signal B18	 : std_logic := '0';
         
signal C1	 : std_logic := '0';
signal C2	 : std_logic := '0';
signal C3	 : std_logic := '0';
signal C4	 : std_logic := '0';
signal C5	 : std_logic := '0';
signal C6	 : std_logic := '0';
signal C7	 : std_logic := '0';
signal C8	 : std_logic := '0';
signal C9	 : std_logic := '0';
signal C10	 : std_logic := '0';
signal C11	 : std_logic := '0';
signal C12	 : std_logic := '0';
signal C13	 : std_logic := '0';
signal C14	 : std_logic := '0';
signal C15	 : std_logic := '0';
signal C16	 : std_logic := '0';
signal C17	 : std_logic := '0';
signal C18	 : std_logic := '0';
signal C19	 : std_logic := '0';
signal C20	 : std_logic := '0';
signal C21	 : std_logic := '0';
signal C22	 : std_logic := '0';
signal C23	 : std_logic := '0';
signal C24	 : std_logic := '0';
signal C25	 : std_logic := '0';
signal C26	 : std_logic := '0';
signal C27	 : std_logic := '0';
signal C28	 : std_logic := '0';
signal C29	 : std_logic := '0';
signal C30	 : std_logic := '0';
signal C31	 : std_logic := '0';
signal C32	 : std_logic := '0';
signal C33	 : std_logic := '0';
signal C34	 : std_logic := '0';
signal C35	 : std_logic := '0';
signal C36	 : std_logic := '0';

signal CAI1	 : std_logic := '0';
signal CAI2	 : std_logic := '0';
signal CAI3	 : std_logic := '0';
signal CAI4	 : std_logic := '0';
signal CAI5	 : std_logic := '0';
signal CAI6	 : std_logic := '0';
signal CAI7	 : std_logic := '0';
signal CAI8	 : std_logic := '0';
signal CAI9	 : std_logic := '0';
signal CAI10     : std_logic := '0';
signal CAI11     : std_logic := '0';
signal CAI12     : std_logic := '0';
signal CAI13     : std_logic := '0';
signal CAI14     : std_logic := '0';
signal CAI15     : std_logic := '0';
signal CAI16     : std_logic := '0';
signal CAI17     : std_logic := '0';
signal CAI18     : std_logic := '0';
         
signal CAO1	 : std_logic := '0';
signal CAO2	 : std_logic := '0';
signal CAO3	 : std_logic := '0';
signal CAO4	 : std_logic := '0';
signal CAO5	 : std_logic := '0';
signal CAO6	 : std_logic := '0';
signal CAO7	 : std_logic := '0';
signal CAO8	 : std_logic := '0';
signal CAO9	 : std_logic := '0';
signal CAO10     : std_logic := '0';
signal CAO11     : std_logic := '0';
signal CAO12     : std_logic := '0';
signal CAO13     : std_logic := '0';
signal CAO14     : std_logic := '0';
signal CAO15     : std_logic := '0';
signal CAO16     : std_logic := '0';
signal CAO17     : std_logic := '0';
signal CAO18     : std_logic := '0';

signal CBI1	 : std_logic := '0';
signal CBI2	 : std_logic := '0';
signal CBI3	 : std_logic := '0';
signal CBI4	 : std_logic := '0';
signal CBI5	 : std_logic := '0';
signal CBI6	 : std_logic := '0';
signal CBI7	 : std_logic := '0';
signal CBI8	 : std_logic := '0';
signal CBI9	 : std_logic := '0';
signal CBI10     : std_logic := '0';
signal CBI11     : std_logic := '0';
signal CBI12     : std_logic := '0';
signal CBI13     : std_logic := '0';
signal CBI14     : std_logic := '0';
signal CBI15     : std_logic := '0';
signal CBI16     : std_logic := '0';
signal CBI17     : std_logic := '0';
signal CBI18     : std_logic := '0';

signal CBO1	 : std_logic := '0';
signal CBO2	 : std_logic := '0';
signal CBO3	 : std_logic := '0';
signal CBO4	 : std_logic := '0';
signal CBO5	 : std_logic := '0';
signal CBO6	 : std_logic := '0';
signal CBO7	 : std_logic := '0';
signal CBO8	 : std_logic := '0';
signal CBO9	 : std_logic := '0';
signal CBO10     : std_logic := '0';
signal CBO11     : std_logic := '0';
signal CBO12     : std_logic := '0';
signal CBO13     : std_logic := '0';
signal CBO14     : std_logic := '0';
signal CBO15     : std_logic := '0';
signal CBO16     : std_logic := '0';
signal CBO17     : std_logic := '0';
signal CBO18     : std_logic := '0';

signal CO37	 : std_logic := '0';
signal CO49	 : std_logic := '0';
        
signal CZI1	 : std_logic := '0';
signal CZI2	 : std_logic := '0';
signal CZI3	 : std_logic := '0';
signal CZI4	 : std_logic := '0';
signal CZI5	 : std_logic := '0';
signal CZI6	 : std_logic := '0';
signal CZI7	 : std_logic := '0';
signal CZI8	 : std_logic := '0';
signal CZI9	 : std_logic := '0';
signal CZI10     : std_logic := '0';
signal CZI11     : std_logic := '0';
signal CZI12     : std_logic := '0';
signal CZI13     : std_logic := '0';
signal CZI14     : std_logic := '0';
signal CZI15     : std_logic := '0';
signal CZI16     : std_logic := '0';
signal CZI17     : std_logic := '0';
signal CZI18     : std_logic := '0';
signal CZI19     : std_logic := '0';
signal CZI20     : std_logic := '0';
signal CZI21     : std_logic := '0';
signal CZI22     : std_logic := '0';
signal CZI23     : std_logic := '0';
signal CZI24     : std_logic := '0';
signal CZI25     : std_logic := '0';
signal CZI26     : std_logic := '0';
signal CZI27     : std_logic := '0';
signal CZI28     : std_logic := '0';
signal CZI29     : std_logic := '0';
signal CZI30     : std_logic := '0';
signal CZI31     : std_logic := '0';
signal CZI32     : std_logic := '0';
signal CZI33     : std_logic := '0';
signal CZI34     : std_logic := '0';
signal CZI35     : std_logic := '0';
signal CZI36     : std_logic := '0';
signal CZI37     : std_logic := '0';
signal CZI38     : std_logic := '0';
signal CZI39     : std_logic := '0';
signal CZI40     : std_logic := '0';
signal CZI41     : std_logic := '0';
signal CZI42     : std_logic := '0';
signal CZI43     : std_logic := '0';
signal CZI44     : std_logic := '0';
signal CZI45     : std_logic := '0';
signal CZI46     : std_logic := '0';
signal CZI47     : std_logic := '0';
signal CZI48     : std_logic := '0';
signal CZI49     : std_logic := '0';
signal CZI50     : std_logic := '0';
signal CZI51     : std_logic := '0';
signal CZI52     : std_logic := '0';
signal CZI53     : std_logic := '0';
signal CZI54     : std_logic := '0';
signal CZI55     : std_logic := '0';
signal CZI56     : std_logic := '0';

signal CZO1	 : std_logic := '0';
signal CZO2	 : std_logic := '0';
signal CZO3	 : std_logic := '0';
signal CZO4	 : std_logic := '0';
signal CZO5	 : std_logic := '0';
signal CZO6	 : std_logic := '0';
signal CZO7	 : std_logic := '0';
signal CZO8	 : std_logic := '0';
signal CZO9	 : std_logic := '0';
signal CZO10     : std_logic := '0';
signal CZO11     : std_logic := '0';
signal CZO12     : std_logic := '0';
signal CZO13     : std_logic := '0';
signal CZO14     : std_logic := '0';
signal CZO15     : std_logic := '0';
signal CZO16     : std_logic := '0';
signal CZO17     : std_logic := '0';
signal CZO18     : std_logic := '0';
signal CZO19     : std_logic := '0';
signal CZO20     : std_logic := '0';
signal CZO21     : std_logic := '0';
signal CZO22     : std_logic := '0';
signal CZO23     : std_logic := '0';
signal CZO24     : std_logic := '0';
signal CZO25     : std_logic := '0';
signal CZO26     : std_logic := '0';
signal CZO27     : std_logic := '0';
signal CZO28     : std_logic := '0';
signal CZO29     : std_logic := '0';
signal CZO30     : std_logic := '0';
signal CZO31     : std_logic := '0';
signal CZO32     : std_logic := '0';
signal CZO33     : std_logic := '0';
signal CZO34     : std_logic := '0';
signal CZO35     : std_logic := '0';
signal CZO36     : std_logic := '0';
signal CZO37     : std_logic := '0';
signal CZO38     : std_logic := '0';
signal CZO39     : std_logic := '0';
signal CZO40     : std_logic := '0';
signal CZO41     : std_logic := '0';
signal CZO42     : std_logic := '0';
signal CZO43     : std_logic := '0';
signal CZO44     : std_logic := '0';
signal CZO45     : std_logic := '0';
signal CZO46     : std_logic := '0';
signal CZO47     : std_logic := '0';
signal CZO48     : std_logic := '0';
signal CZO49     : std_logic := '0';
signal CZO50     : std_logic := '0';
signal CZO51     : std_logic := '0';
signal CZO52     : std_logic := '0';
signal CZO53     : std_logic := '0';
signal CZO54     : std_logic := '0';
signal CZO55     : std_logic := '0';
signal CZO56     : std_logic := '0';

signal D1	 : std_logic := '0';
signal D2	 : std_logic := '0';
signal D3	 : std_logic := '0';
signal D4	 : std_logic := '0';
signal D5	 : std_logic := '0';
signal D6	 : std_logic := '0';
signal D7	 : std_logic := '0';
signal D8	 : std_logic := '0';
signal D9	 : std_logic := '0';
signal D10	 : std_logic := '0';
signal D11	 : std_logic := '0';
signal D12	 : std_logic := '0';
signal D13	 : std_logic := '0';
signal D14	 : std_logic := '0';
signal D15	 : std_logic := '0';
signal D16	 : std_logic := '0';
signal D17	 : std_logic := '0';
signal D18	 : std_logic := '0';
         
signal Z1	 : std_logic := '0';
signal Z2	 : std_logic := '0';
signal Z3	 : std_logic := '0';
signal Z4	 : std_logic := '0';
signal Z5	 : std_logic := '0';
signal Z6	 : std_logic := '0';
signal Z7	 : std_logic := '0';
signal Z8	 : std_logic := '0';
signal Z9	 : std_logic := '0';
signal Z10	 : std_logic := '0';
signal Z11	 : std_logic := '0';
signal Z12	 : std_logic := '0';
signal Z13	 : std_logic := '0';
signal Z14	 : std_logic := '0';
signal Z15	 : std_logic := '0';
signal Z16	 : std_logic := '0';
signal Z17	 : std_logic := '0';
signal Z18	 : std_logic := '0';
signal Z19	 : std_logic := '0';
signal Z20	 : std_logic := '0';
signal Z21	 : std_logic := '0';
signal Z22	 : std_logic := '0';
signal Z23	 : std_logic := '0';
signal Z24	 : std_logic := '0';
signal Z25	 : std_logic := '0';
signal Z26	 : std_logic := '0';
signal Z27	 : std_logic := '0';
signal Z28	 : std_logic := '0';
signal Z29	 : std_logic := '0';
signal Z30	 : std_logic := '0';
signal Z31	 : std_logic := '0';
signal Z32	 : std_logic := '0';
signal Z33	 : std_logic := '0';
signal Z34	 : std_logic := '0';
signal Z35	 : std_logic := '0';
signal Z36	 : std_logic := '0';
signal Z37	 : std_logic := '0';
signal Z38	 : std_logic := '0';
signal Z39	 : std_logic := '0';
signal Z40	 : std_logic := '0';
signal Z41	 : std_logic := '0';
signal Z42	 : std_logic := '0';
signal Z43	 : std_logic := '0';
signal Z44	 : std_logic := '0';
signal Z45	 : std_logic := '0';
signal Z46	 : std_logic := '0';
signal Z47	 : std_logic := '0';
signal Z48	 : std_logic := '0';
signal Z49	 : std_logic := '0';
signal Z50	 : std_logic := '0';
signal Z51	 : std_logic := '0';
signal Z52	 : std_logic := '0';
signal Z53	 : std_logic := '0';
signal Z54	 : std_logic := '0';
signal Z55	 : std_logic := '0';


constant raw_config0_gen : std_logic_vector(19 downto 0)
                := CO_SEL & ALU_DYNAMIC_OP & SATURATION_RANK & ENABLE_SATURATION & Z_FEEDBACK_SHL12               
                   & MUX_Z & MUX_CI & MUX_Y & MUX_X & MUX_P & MUX_B & MUX_A & PRE_ADDER_OP & SIGNED_MODE;           
                                                                                                              
                                                                                                              
constant raw_config1_gen : std_logic_vector(21 downto 0)
                := "000" & PR_OV_MUX & PR_CO_MUX & PR_Z_MUX                                            
                   & PR_ALU_MUX & PR_MULT_MUX & PR_Y_MUX & PR_X_MUX & PR_P_MUX & PR_CI_MUX                         
                   & PR_D_MUX & PR_C_MUX & PR_B_CASCADE_MUX & PR_B_MUX & PR_A_CASCADE_MUX & PR_A_MUX;              
                                                                                                              
                                                                                                           
constant raw_config2_gen : std_logic_vector(12 downto 0)
               := ENABLE_PR_OV_RST & ENABLE_PR_CO_RST & ENABLE_PR_Z_RST & ENABLE_PR_ALU_RST                 
                  & ENABLE_PR_MULT_RST & ENABLE_PR_Y_RST & ENABLE_PR_X_RST & ENABLE_PR_P_RST                  
                  & ENABLE_PR_CI_RST & ENABLE_PR_D_RST & ENABLE_PR_C_RST & ENABLE_PR_B_RST & ENABLE_PR_A_RST; 
                                                                                                           
                                                                                                           
constant raw_config3_gen : std_logic_vector(6 downto 0) := ALU_MUX & ALU_OP;                                                                          


----------------------------------------------------------
-- NX_DSP declaration
----------------------------------------------------------
component NX_DSP 
generic (
   std_mode    : string := ""; -- standard mode [ADD36, SUB36, SMUL18, UMUL18, ...] empty for raw
   raw_config0 : bit_vector(19 downto 0) := B"00000000000000000000";	-- MUX
   raw_config1 : bit_vector(21 downto 0) := B"0000000000000000000000";	-- PRC
   raw_config2 : bit_vector(12 downto 0) := B"0000000000000";		-- PRR
   raw_config3 : bit_vector( 6 downto 0) := B"0000000"			-- ALU
   );
port (
   A1	 : in std_logic := '0';
   A2	 : in std_logic := '0';
   A3	 : in std_logic := '0';
   A4	 : in std_logic := '0';
   A5	 : in std_logic := '0';
   A6	 : in std_logic := '0';
   A7	 : in std_logic := '0';
   A8	 : in std_logic := '0';
   A9	 : in std_logic := '0';
   A10	 : in std_logic := '0';
   A11	 : in std_logic := '0';
   A12	 : in std_logic := '0';
   A13	 : in std_logic := '0';
   A14	 : in std_logic := '0';
   A15	 : in std_logic := '0';
   A16	 : in std_logic := '0';
   A17	 : in std_logic := '0';
   A18	 : in std_logic := '0';
   A19	 : in std_logic := '0';
   A20	 : in std_logic := '0';
   A21	 : in std_logic := '0';
   A22	 : in std_logic := '0';
   A23	 : in std_logic := '0';
   A24	 : in std_logic := '0';
         
   B1	 : in std_logic := '0';
   B2	 : in std_logic := '0';
   B3	 : in std_logic := '0';
   B4	 : in std_logic := '0';
   B5	 : in std_logic := '0';
   B6	 : in std_logic := '0';
   B7	 : in std_logic := '0';
   B8	 : in std_logic := '0';
   B9	 : in std_logic := '0';
   B10	 : in std_logic := '0';
   B11	 : in std_logic := '0';
   B12	 : in std_logic := '0';
   B13	 : in std_logic := '0';
   B14	 : in std_logic := '0';
   B15	 : in std_logic := '0';
   B16	 : in std_logic := '0';
   B17	 : in std_logic := '0';
   B18	 : in std_logic := '0';
         
   C1	 : in std_logic := '0';
   C2	 : in std_logic := '0';
   C3	 : in std_logic := '0';
   C4	 : in std_logic := '0';
   C5	 : in std_logic := '0';
   C6	 : in std_logic := '0';
   C7	 : in std_logic := '0';
   C8	 : in std_logic := '0';
   C9	 : in std_logic := '0';
   C10	 : in std_logic := '0';
   C11	 : in std_logic := '0';
   C12	 : in std_logic := '0';
   C13	 : in std_logic := '0';
   C14	 : in std_logic := '0';
   C15	 : in std_logic := '0';
   C16	 : in std_logic := '0';
   C17	 : in std_logic := '0';
   C18	 : in std_logic := '0';
   C19	 : in std_logic := '0';
   C20	 : in std_logic := '0';
   C21	 : in std_logic := '0';
   C22	 : in std_logic := '0';
   C23	 : in std_logic := '0';
   C24	 : in std_logic := '0';
   C25	 : in std_logic := '0';
   C26	 : in std_logic := '0';
   C27	 : in std_logic := '0';
   C28	 : in std_logic := '0';
   C29	 : in std_logic := '0';
   C30	 : in std_logic := '0';
   C31	 : in std_logic := '0';
   C32	 : in std_logic := '0';
   C33	 : in std_logic := '0';
   C34	 : in std_logic := '0';
   C35	 : in std_logic := '0';
   C36	 : in std_logic := '0';

   CAI1	 : in std_logic := '0';
   CAI2	 : in std_logic := '0';
   CAI3	 : in std_logic := '0';
   CAI4	 : in std_logic := '0';
   CAI5	 : in std_logic := '0';
   CAI6	 : in std_logic := '0';
   CAI7	 : in std_logic := '0';
   CAI8	 : in std_logic := '0';
   CAI9	 : in std_logic := '0';
   CAI10 : in std_logic := '0';
   CAI11 : in std_logic := '0';
   CAI12 : in std_logic := '0';
   CAI13 : in std_logic := '0';
   CAI14 : in std_logic := '0';
   CAI15 : in std_logic := '0';
   CAI16 : in std_logic := '0';
   CAI17 : in std_logic := '0';
   CAI18 : in std_logic := '0';
         
   CAO1	 : out std_logic := '0';
   CAO2	 : out std_logic := '0';
   CAO3	 : out std_logic := '0';
   CAO4	 : out std_logic := '0';
   CAO5	 : out std_logic := '0';
   CAO6	 : out std_logic := '0';
   CAO7	 : out std_logic := '0';
   CAO8	 : out std_logic := '0';
   CAO9	 : out std_logic := '0';
   CAO10 : out std_logic := '0';
   CAO11 : out std_logic := '0';
   CAO12 : out std_logic := '0';
   CAO13 : out std_logic := '0';
   CAO14 : out std_logic := '0';
   CAO15 : out std_logic := '0';
   CAO16 : out std_logic := '0';
   CAO17 : out std_logic := '0';
   CAO18 : out std_logic := '0';

   CBI1	 : in std_logic := '0';
   CBI2	 : in std_logic := '0';
   CBI3	 : in std_logic := '0';
   CBI4	 : in std_logic := '0';
   CBI5	 : in std_logic := '0';
   CBI6	 : in std_logic := '0';
   CBI7	 : in std_logic := '0';
   CBI8	 : in std_logic := '0';
   CBI9	 : in std_logic := '0';
   CBI10 : in std_logic := '0';
   CBI11 : in std_logic := '0';
   CBI12 : in std_logic := '0';
   CBI13 : in std_logic := '0';
   CBI14 : in std_logic := '0';
   CBI15 : in std_logic := '0';
   CBI16 : in std_logic := '0';
   CBI17 : in std_logic := '0';
   CBI18 : in std_logic := '0';

   CBO1	 : out std_logic := '0';
   CBO2	 : out std_logic := '0';
   CBO3	 : out std_logic := '0';
   CBO4	 : out std_logic := '0';
   CBO5	 : out std_logic := '0';
   CBO6	 : out std_logic := '0';
   CBO7	 : out std_logic := '0';
   CBO8	 : out std_logic := '0';
   CBO9	 : out std_logic := '0';
   CBO10 : out std_logic := '0';
   CBO11 : out std_logic := '0';
   CBO12 : out std_logic := '0';
   CBO13 : out std_logic := '0';
   CBO14 : out std_logic := '0';
   CBO15 : out std_logic := '0';
   CBO16 : out std_logic := '0';
   CBO17 : out std_logic := '0';
   CBO18 : out std_logic := '0';

   CCI	 : in std_logic := '0';
   CCO	 : out std_logic := '0';
   CI	 : in std_logic := '0';
   CK	 : in std_logic := '0';
   CO	 : out std_logic := '0';
   CO37	 : out std_logic := '0';
   CO49	 : out std_logic := '0';
        
   CZI1	 : in std_logic := '0';
   CZI2	 : in std_logic := '0';
   CZI3	 : in std_logic := '0';
   CZI4	 : in std_logic := '0';
   CZI5	 : in std_logic := '0';
   CZI6	 : in std_logic := '0';
   CZI7	 : in std_logic := '0';
   CZI8	 : in std_logic := '0';
   CZI9	 : in std_logic := '0';
   CZI10 : in std_logic := '0';
   CZI11 : in std_logic := '0';
   CZI12 : in std_logic := '0';
   CZI13 : in std_logic := '0';
   CZI14 : in std_logic := '0';
   CZI15 : in std_logic := '0';
   CZI16 : in std_logic := '0';
   CZI17 : in std_logic := '0';
   CZI18 : in std_logic := '0';
   CZI19 : in std_logic := '0';
   CZI20 : in std_logic := '0';
   CZI21 : in std_logic := '0';
   CZI22 : in std_logic := '0';
   CZI23 : in std_logic := '0';
   CZI24 : in std_logic := '0';
   CZI25 : in std_logic := '0';
   CZI26 : in std_logic := '0';
   CZI27 : in std_logic := '0';
   CZI28 : in std_logic := '0';
   CZI29 : in std_logic := '0';
   CZI30 : in std_logic := '0';
   CZI31 : in std_logic := '0';
   CZI32 : in std_logic := '0';
   CZI33 : in std_logic := '0';
   CZI34 : in std_logic := '0';
   CZI35 : in std_logic := '0';
   CZI36 : in std_logic := '0';
   CZI37 : in std_logic := '0';
   CZI38 : in std_logic := '0';
   CZI39 : in std_logic := '0';
   CZI40 : in std_logic := '0';
   CZI41 : in std_logic := '0';
   CZI42 : in std_logic := '0';
   CZI43 : in std_logic := '0';
   CZI44 : in std_logic := '0';
   CZI45 : in std_logic := '0';
   CZI46 : in std_logic := '0';
   CZI47 : in std_logic := '0';
   CZI48 : in std_logic := '0';
   CZI49 : in std_logic := '0';
   CZI50 : in std_logic := '0';
   CZI51 : in std_logic := '0';
   CZI52 : in std_logic := '0';
   CZI53 : in std_logic := '0';
   CZI54 : in std_logic := '0';
   CZI55 : in std_logic := '0';
   CZI56 : in std_logic := '0';

   CZO1	 : out std_logic := '0';
   CZO2	 : out std_logic := '0';
   CZO3	 : out std_logic := '0';
   CZO4	 : out std_logic := '0';
   CZO5	 : out std_logic := '0';
   CZO6	 : out std_logic := '0';
   CZO7	 : out std_logic := '0';
   CZO8	 : out std_logic := '0';
   CZO9	 : out std_logic := '0';
   CZO10 : out std_logic := '0';
   CZO11 : out std_logic := '0';
   CZO12 : out std_logic := '0';
   CZO13 : out std_logic := '0';
   CZO14 : out std_logic := '0';
   CZO15 : out std_logic := '0';
   CZO16 : out std_logic := '0';
   CZO17 : out std_logic := '0';
   CZO18 : out std_logic := '0';
   CZO19 : out std_logic := '0';
   CZO20 : out std_logic := '0';
   CZO21 : out std_logic := '0';
   CZO22 : out std_logic := '0';
   CZO23 : out std_logic := '0';
   CZO24 : out std_logic := '0';
   CZO25 : out std_logic := '0';
   CZO26 : out std_logic := '0';
   CZO27 : out std_logic := '0';
   CZO28 : out std_logic := '0';
   CZO29 : out std_logic := '0';
   CZO30 : out std_logic := '0';
   CZO31 : out std_logic := '0';
   CZO32 : out std_logic := '0';
   CZO33 : out std_logic := '0';
   CZO34 : out std_logic := '0';
   CZO35 : out std_logic := '0';
   CZO36 : out std_logic := '0';
   CZO37 : out std_logic := '0';
   CZO38 : out std_logic := '0';
   CZO39 : out std_logic := '0';
   CZO40 : out std_logic := '0';
   CZO41 : out std_logic := '0';
   CZO42 : out std_logic := '0';
   CZO43 : out std_logic := '0';
   CZO44 : out std_logic := '0';
   CZO45 : out std_logic := '0';
   CZO46 : out std_logic := '0';
   CZO47 : out std_logic := '0';
   CZO48 : out std_logic := '0';
   CZO49 : out std_logic := '0';
   CZO50 : out std_logic := '0';
   CZO51 : out std_logic := '0';
   CZO52 : out std_logic := '0';
   CZO53 : out std_logic := '0';
   CZO54 : out std_logic := '0';
   CZO55 : out std_logic := '0';
   CZO56 : out std_logic := '0';

   D1	 : in std_logic := '0';
   D2	 : in std_logic := '0';
   D3	 : in std_logic := '0';
   D4	 : in std_logic := '0';
   D5	 : in std_logic := '0';
   D6	 : in std_logic := '0';
   D7	 : in std_logic := '0';
   D8	 : in std_logic := '0';
   D9	 : in std_logic := '0';
   D10	 : in std_logic := '0';
   D11	 : in std_logic := '0';
   D12	 : in std_logic := '0';
   D13	 : in std_logic := '0';
   D14	 : in std_logic := '0';
   D15	 : in std_logic := '0';
   D16	 : in std_logic := '0';
   D17	 : in std_logic := '0';
   D18	 : in std_logic := '0';
         
   OVF	 : out std_logic := '0';
   R	 : in std_logic := '0';
   RZ	 : in std_logic := '0';
   WE	 : in std_logic := '0';
         
   Z1	 : out std_logic := '0';
   Z2	 : out std_logic := '0';
   Z3	 : out std_logic := '0';
   Z4	 : out std_logic := '0';
   Z5	 : out std_logic := '0';
   Z6	 : out std_logic := '0';
   Z7	 : out std_logic := '0';
   Z8	 : out std_logic := '0';
   Z9	 : out std_logic := '0';
   Z10	 : out std_logic := '0';
   Z11	 : out std_logic := '0';
   Z12	 : out std_logic := '0';
   Z13	 : out std_logic := '0';
   Z14	 : out std_logic := '0';
   Z15	 : out std_logic := '0';
   Z16	 : out std_logic := '0';
   Z17	 : out std_logic := '0';
   Z18	 : out std_logic := '0';
   Z19	 : out std_logic := '0';
   Z20	 : out std_logic := '0';
   Z21	 : out std_logic := '0';
   Z22	 : out std_logic := '0';
   Z23	 : out std_logic := '0';
   Z24	 : out std_logic := '0';
   Z25	 : out std_logic := '0';
   Z26	 : out std_logic := '0';
   Z27	 : out std_logic := '0';
   Z28	 : out std_logic := '0';
   Z29	 : out std_logic := '0';
   Z30	 : out std_logic := '0';
   Z31	 : out std_logic := '0';
   Z32	 : out std_logic := '0';
   Z33	 : out std_logic := '0';
   Z34	 : out std_logic := '0';
   Z35	 : out std_logic := '0';
   Z36	 : out std_logic := '0';
   Z37	 : out std_logic := '0';
   Z38	 : out std_logic := '0';
   Z39	 : out std_logic := '0';
   Z40	 : out std_logic := '0';
   Z41	 : out std_logic := '0';
   Z42	 : out std_logic := '0';
   Z43	 : out std_logic := '0';
   Z44	 : out std_logic := '0';
   Z45	 : out std_logic := '0';
   Z46	 : out std_logic := '0';
   Z47	 : out std_logic := '0';
   Z48	 : out std_logic := '0';
   Z49	 : out std_logic := '0';
   Z50	 : out std_logic := '0';
   Z51	 : out std_logic := '0';
   Z52	 : out std_logic := '0';
   Z53	 : out std_logic := '0';
   Z54	 : out std_logic := '0';
   Z55	 : out std_logic := '0';
   Z56	 : out std_logic := '0'
   );
end component;



begin

-------------------------
-------------------------
-- translate_off
-------------------------
-------------------------
-------------------------
-- translate_on
-------------------------
-------------------------


----------------------------------------------------------
-- Instantiation the NX_DSP component
----------------------------------------------------------
DSP_INST : NX_DSP 
generic map (
   std_mode    => "", -- standard mode [ADD36, SUB36, SMUL18, UMUL18, ...] empty for raw
   raw_config0 => To_bitvector(raw_config0_gen), -- MODE and MUXes
   raw_config1 => To_bitvector(raw_config1_gen), -- Pipeline Registers
   raw_config2 => To_bitvector(raw_config2_gen), -- Reset Enable for internal registers
   raw_config3 => To_bitvector(raw_config3_gen)  -- ALU modes
   )
port map (
   A1	 => A(0),
   A2	 => A(1),
   A3	 => A(2),
   A4	 => A(3),
   A5	 => A(4),
   A6	 => A(5),
   A7	 => A(6),
   A8	 => A(7),
   A9	 => A(8),
   A10	 => A(9),
   A11	 => A(10),
   A12	 => A(11),
   A13	 => A(12),
   A14	 => A(13),
   A15	 => A(14),
   A16	 => A(15),
   A17	 => A(16),
   A18	 => A(17),
   A19	 => A(18),
   A20	 => A(19),
   A21	 => A(20),
   A22	 => A(21),
   A23	 => A(22),
   A24	 => A(23),
         
   B1	 => B(0), 
   B2	 => B(1), 
   B3	 => B(2), 
   B4	 => B(3), 
   B5	 => B(4), 
   B6	 => B(5), 
   B7	 => B(6), 
   B8	 => B(7), 
   B9	 => B(8), 
   B10	 => B(9), 
   B11	 => B(10),
   B12	 => B(11),
   B13	 => B(12),
   B14	 => B(13),
   B15	 => B(14),
   B16	 => B(15),
   B17	 => B(16),
   B18	 => B(17),
        
   C1	 => C(0), 
   C2	 => C(1), 
   C3	 => C(2), 
   C4	 => C(3), 
   C5	 => C(4), 
   C6	 => C(5), 
   C7	 => C(6), 
   C8	 => C(7), 
   C9	 => C(8), 
   C10	 => C(9), 
   C11	 => C(10),
   C12	 => C(11),
   C13	 => C(12),
   C14	 => C(13),
   C15	 => C(14),
   C16	 => C(15),
   C17	 => C(16),
   C18	 => C(17),
   C19	 => C(18),
   C20	 => C(19),
   C21	 => C(20),
   C22	 => C(21),
   C23	 => C(22),
   C24	 => C(23),
   C25	 => C(24), 
   C26	 => C(25), 
   C27	 => C(26), 
   C28	 => C(27), 
   C29	 => C(28), 
   C30	 => C(29), 
   C31	 => C(30), 
   C32	 => C(31), 
   C33	 => C(32), 
   C34	 => C(33), 
   C35	 => C(34), 
   C36	 => C(35), 
        
   CAI1	 => CAI(0),
   CAI2	 => CAI(1),
   CAI3	 => CAI(2),
   CAI4	 => CAI(3),
   CAI5	 => CAI(4),
   CAI6	 => CAI(5),
   CAI7	 => CAI(6),
   CAI8	 => CAI(7),
   CAI9	 => CAI(8),
   CAI10 => CAI(9),
   CAI11 => CAI(10),
   CAI12 => CAI(11),
   CAI13 => CAI(12),
   CAI14 => CAI(13),
   CAI15 => CAI(14),
   CAI16 => CAI(15),
   CAI17 => CAI(16),
   CAI18 => CAI(17),
         
   CAO1	 => CAO(0), 
   CAO2	 => CAO(1), 
   CAO3	 => CAO(2), 
   CAO4	 => CAO(3), 
   CAO5	 => CAO(4), 
   CAO6	 => CAO(5), 
   CAO7	 => CAO(6), 
   CAO8	 => CAO(7), 
   CAO9	 => CAO(8), 
   CAO10 => CAO(9), 
   CAO11 => CAO(10),
   CAO12 => CAO(11),
   CAO13 => CAO(12),
   CAO14 => CAO(13),
   CAO15 => CAO(14),
   CAO16 => CAO(15),
   CAO17 => CAO(16),
   CAO18 => CAO(17),

   CBI1	 => CBI(0), 
   CBI2	 => CBI(1), 
   CBI3	 => CBI(2), 
   CBI4	 => CBI(3), 
   CBI5	 => CBI(4), 
   CBI6	 => CBI(5), 
   CBI7	 => CBI(6), 
   CBI8	 => CBI(7), 
   CBI9	 => CBI(8), 
   CBI10 => CBI(9), 
   CBI11 => CBI(10),
   CBI12 => CBI(11),
   CBI13 => CBI(12),
   CBI14 => CBI(13),
   CBI15 => CBI(14),
   CBI16 => CBI(15),
   CBI17 => CBI(16),
   CBI18 => CBI(17),

   CBO1	 => CBO(0), 
   CBO2	 => CBO(1), 
   CBO3	 => CBO(2), 
   CBO4	 => CBO(3), 
   CBO5	 => CBO(4), 
   CBO6	 => CBO(5), 
   CBO7	 => CBO(6), 
   CBO8	 => CBO(7), 
   CBO9	 => CBO(8), 
   CBO10 => CBO(9), 
   CBO11 => CBO(10),
   CBO12 => CBO(11),
   CBO13 => CBO(12),
   CBO14 => CBO(13),
   CBO15 => CBO(14),
   CBO16 => CBO(15),
   CBO17 => CBO(16),
   CBO18 => CBO(17),

   CCI	 => CCI,
   CCO	 => CCO,
   CI	 => CI,
   CK	 => CK,
   CO	 => CO,
   CO37	 => CO36,
   CO49	 => CO48,
        
   CZI1	 => CZI(0), 
   CZI2	 => CZI(1), 
   CZI3	 => CZI(2), 
   CZI4	 => CZI(3), 
   CZI5	 => CZI(4), 
   CZI6	 => CZI(5), 
   CZI7	 => CZI(6), 
   CZI8	 => CZI(7), 
   CZI9	 => CZI(8), 
   CZI10 => CZI(9), 
   CZI11 => CZI(10),
   CZI12 => CZI(11),
   CZI13 => CZI(12),
   CZI14 => CZI(13),
   CZI15 => CZI(14),
   CZI16 => CZI(15),
   CZI17 => CZI(16),
   CZI18 => CZI(17),
   CZI19 => CZI(18),
   CZI20 => CZI(19),
   CZI21 => CZI(20),
   CZI22 => CZI(21),
   CZI23 => CZI(22),
   CZI24 => CZI(23),
   CZI25 => CZI(24),
   CZI26 => CZI(25),
   CZI27 => CZI(26),
   CZI28 => CZI(27),
   CZI29 => CZI(28),
   CZI30 => CZI(29),
   CZI31 => CZI(30),
   CZI32 => CZI(31),
   CZI33 => CZI(32),
   CZI34 => CZI(33),
   CZI35 => CZI(34),
   CZI36 => CZI(35),
   CZI37 => CZI(36),
   CZI38 => CZI(37),
   CZI39 => CZI(38),
   CZI40 => CZI(39),
   CZI41 => CZI(40),
   CZI42 => CZI(41),
   CZI43 => CZI(42),
   CZI44 => CZI(43),
   CZI45 => CZI(44),
   CZI46 => CZI(45),
   CZI47 => CZI(46),
   CZI48 => CZI(47),
   CZI49 => CZI(48),
   CZI50 => CZI(49),
   CZI51 => CZI(50),
   CZI52 => CZI(51),
   CZI53 => CZI(52),
   CZI54 => CZI(53),
   CZI55 => CZI(54),
   CZI56 => CZI(55),

   CZO1	 => CZO(0), 
   CZO2	 => CZO(1), 
   CZO3	 => CZO(2), 
   CZO4	 => CZO(3), 
   CZO5	 => CZO(4), 
   CZO6	 => CZO(5), 
   CZO7	 => CZO(6), 
   CZO8	 => CZO(7), 
   CZO9	 => CZO(8), 
   CZO10 => CZO(9), 
   CZO11 => CZO(10),
   CZO12 => CZO(11),
   CZO13 => CZO(12),
   CZO14 => CZO(13),
   CZO15 => CZO(14),
   CZO16 => CZO(15),
   CZO17 => CZO(16),
   CZO18 => CZO(17),
   CZO19 => CZO(18), 
   CZO20 => CZO(19),
   CZO21 => CZO(20), 
   CZO22 => CZO(21), 
   CZO23 => CZO(22), 
   CZO24 => CZO(23), 
   CZO25 => CZO(24), 
   CZO26 => CZO(25), 
   CZO27 => CZO(26), 
   CZO28 => CZO(27), 
   CZO29 => CZO(28), 
   CZO30 => CZO(29), 
   CZO31 => CZO(30), 
   CZO32 => CZO(31), 
   CZO33 => CZO(32), 
   CZO34 => CZO(33), 
   CZO35 => CZO(34), 
   CZO36 => CZO(35), 
   CZO37 => CZO(36), 
   CZO38 => CZO(37), 
   CZO39 => CZO(38), 
   CZO40 => CZO(39), 
   CZO41 => CZO(40), 
   CZO42 => CZO(41), 
   CZO43 => CZO(42), 
   CZO44 => CZO(43), 
   CZO45 => CZO(44), 
   CZO46 => CZO(45), 
   CZO47 => CZO(46), 
   CZO48 => CZO(47), 
   CZO49 => CZO(48), 
   CZO50 => CZO(49), 
   CZO51 => CZO(50), 
   CZO52 => CZO(51), 
   CZO53 => CZO(52), 
   CZO54 => CZO(53), 
   CZO55 => CZO(54), 
   CZO56 => CZO(55), 

   D1	 => D(0), 
   D2	 => D(1), 
   D3	 => D(2), 
   D4	 => D(3), 
   D5	 => D(4), 
   D6	 => D(5), 
   D7	 => D(6), 
   D8	 => D(7), 
   D9	 => D(8), 
   D10	 => D(9), 
   D11	 => D(10),
   D12	 => D(11),
   D13	 => D(12),
   D14	 => D(13),
   D15	 => D(14),
   D16	 => D(15),
   D17	 => D(16),
   D18	 => D(17),
         
   OVF    => OVF,
   R	    => R,
   RZ	    => RZ,
   WE	    => WE,
         
   Z1	    => Z(0), 
   Z2	    => Z(1), 
   Z3	    => Z(2), 
   Z4	    => Z(3), 
   Z5	    => Z(4), 
   Z6	    => Z(5), 
   Z7	    => Z(6), 
   Z8	    => Z(7), 
   Z9	    => Z(8), 
   Z10	 => Z(9), 
   Z11	 => Z(10),
   Z12	 => Z(11),
   Z13	 => Z(12),
   Z14	 => Z(13),
   Z15	 => Z(14),
   Z16	 => Z(15),
   Z17	 => Z(16),
   Z18	 => Z(17),
   Z19	 => Z(18), 
   Z20	 => Z(19), 
   Z21	 => Z(20), 
   Z22	 => Z(21), 
   Z23	 => Z(22), 
   Z24	 => Z(23), 
   Z25	 => Z(24), 
   Z26	 => Z(25), 
   Z27	 => Z(26), 
   Z28	 => Z(27), 
   Z29	 => Z(28), 
   Z30	 => Z(29), 
   Z31	 => Z(30), 
   Z32	 => Z(31), 
   Z33	 => Z(32), 
   Z34	 => Z(33), 
   Z35	 => Z(34), 
   Z36	 => Z(35), 
   Z37	 => Z(36), 
   Z38	 => Z(37), 
   Z39	 => Z(38), 
   Z40	 => Z(39), 
   Z41	 => Z(40), 
   Z42	 => Z(41), 
   Z43	 => Z(42), 
   Z44	 => Z(43), 
   Z45	 => Z(44), 
   Z46	 => Z(45), 
   Z47	 => Z(46), 
   Z48	 => Z(47), 
   Z49	 => Z(48), 
   Z50	 => Z(49), 
   Z51	 => Z(50), 
   Z52	 => Z(51), 
   Z53	 => Z(52), 
   Z54	 => Z(53), 
   Z55	 => Z(54), 
   Z56    => Z(55) 
   );

end Behavioral;

