-- NanoXplore Simulation File
--
-- Date    : 26/03/2018
--

library ieee;
use ieee.std_logic_1164.all;

library NX;
use NX.nxPackage.all;

entity TOP_NX_SYSTOLIC_FIR is
port (
  CLK                 : in    std_logic;
  DIN                 : in    std_logic_vector(15 downto 0);
  DOUT                : out   std_logic_vector(15 downto 0);
  ENA                 : in    std_logic;
  OVF                 : out   std_logic;
  SRST                : in    std_logic);
end TOP_NX_SYSTOLIC_FIR;

architecture mapped of TOP_NX_SYSTOLIC_FIR is
  signal OVF_INT             : std_logic;
  signal OVF_INT_R           : std_logic;
  signal global_0            : std_logic;
  signal global_1            : std_logic;
  signal DIN_R1              : std_logic_vector(15 downto 0);
  signal DIN_R2              : std_logic_vector(15 downto 0);
  signal DOUT_INT            : std_logic_vector(15 downto 0);
  signal FIR_CASC_B_0        : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_1        : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_10       : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_11       : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_12       : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_2        : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_3        : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_4        : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_5        : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_6        : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_7        : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_8        : std_logic_vector(17 downto 0);
  signal FIR_CASC_B_9        : std_logic_vector(17 downto 0);
  signal FIR_CASC_Z_0        : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_1        : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_10       : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_11       : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_12       : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_2        : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_3        : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_4        : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_5        : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_6        : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_7        : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_8        : std_logic_vector(55 downto 0);
  signal FIR_CASC_Z_9        : std_logic_vector(55 downto 0);
  signal FIR_OUT             : std_logic_vector(29 downto 14);
  signal NXP_DUMP            : std_logic := '0';

begin
global_0 <= '0';
global_1 <= '1';


  i_DIN_R1_reg_0 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(0)
      , le   => OPEN
      , q    => DIN_R1(0)
      , rst  => OPEN
    );

  i_DIN_R1_reg_1 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(1)
      , le   => OPEN
      , q    => DIN_R1(1)
      , rst  => OPEN
    );

  i_DIN_R1_reg_2 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(2)
      , le   => OPEN
      , q    => DIN_R1(2)
      , rst  => OPEN
    );

  i_DIN_R1_reg_3 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(3)
      , le   => OPEN
      , q    => DIN_R1(3)
      , rst  => OPEN
    );

  i_DIN_R1_reg_4 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(4)
      , le   => OPEN
      , q    => DIN_R1(4)
      , rst  => OPEN
    );

  i_DIN_R1_reg_5 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(5)
      , le   => OPEN
      , q    => DIN_R1(5)
      , rst  => OPEN
    );

  i_DIN_R1_reg_6 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(6)
      , le   => OPEN
      , q    => DIN_R1(6)
      , rst  => OPEN
    );

  i_DIN_R1_reg_7 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(7)
      , le   => OPEN
      , q    => DIN_R1(7)
      , rst  => OPEN
    );

  i_DIN_R1_reg_8 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(8)
      , le   => OPEN
      , q    => DIN_R1(8)
      , rst  => OPEN
    );

  i_DIN_R1_reg_9 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(9)
      , le   => OPEN
      , q    => DIN_R1(9)
      , rst  => OPEN
    );

  i_DIN_R1_reg_10 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(10)
      , le   => OPEN
      , q    => DIN_R1(10)
      , rst  => OPEN
    );

  i_DIN_R1_reg_11 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(11)
      , le   => OPEN
      , q    => DIN_R1(11)
      , rst  => OPEN
    );

  i_DIN_R1_reg_12 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(12)
      , le   => OPEN
      , q    => DIN_R1(12)
      , rst  => OPEN
    );

  i_DIN_R1_reg_13 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(13)
      , le   => OPEN
      , q    => DIN_R1(13)
      , rst  => OPEN
    );

  i_DIN_R1_reg_14 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(14)
      , le   => OPEN
      , q    => DIN_R1(14)
      , rst  => OPEN
    );

  i_DIN_R1_reg_15 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DIN(15)
      , le   => OPEN
      , q    => DIN_R1(15)
      , rst  => OPEN
    );

  i_DOUT_reg_0 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(0)
      , le   => OPEN
      , q    => DOUT(0)
      , rst  => OPEN
    );

  i_DOUT_reg_1 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(1)
      , le   => OPEN
      , q    => DOUT(1)
      , rst  => OPEN
    );

  i_DOUT_reg_2 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(2)
      , le   => OPEN
      , q    => DOUT(2)
      , rst  => OPEN
    );

  i_DOUT_reg_3 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(3)
      , le   => OPEN
      , q    => DOUT(3)
      , rst  => OPEN
    );

  i_DOUT_reg_4 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(4)
      , le   => OPEN
      , q    => DOUT(4)
      , rst  => OPEN
    );

  i_DOUT_reg_5 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(5)
      , le   => OPEN
      , q    => DOUT(5)
      , rst  => OPEN
    );

  i_DOUT_reg_6 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(6)
      , le   => OPEN
      , q    => DOUT(6)
      , rst  => OPEN
    );

  i_DOUT_reg_7 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(7)
      , le   => OPEN
      , q    => DOUT(7)
      , rst  => OPEN
    );

  i_DOUT_reg_8 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(8)
      , le   => OPEN
      , q    => DOUT(8)
      , rst  => OPEN
    );

  i_DOUT_reg_9 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(9)
      , le   => OPEN
      , q    => DOUT(9)
      , rst  => OPEN
    );

  i_DOUT_reg_10 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(10)
      , le   => OPEN
      , q    => DOUT(10)
      , rst  => OPEN
    );

  i_DOUT_reg_11 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(11)
      , le   => OPEN
      , q    => DOUT(11)
      , rst  => OPEN
    );

  i_DOUT_reg_12 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(12)
      , le   => OPEN
      , q    => DOUT(12)
      , rst  => OPEN
    );

  i_DOUT_reg_13 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(13)
      , le   => OPEN
      , q    => DOUT(13)
      , rst  => OPEN
    );

  i_DOUT_reg_14 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(14)
      , le   => OPEN
      , q    => DOUT(14)
      , rst  => OPEN
    );

  i_DOUT_reg_15 : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => DOUT_INT(15)
      , le   => OPEN
      , q    => DOUT(15)
      , rst  => OPEN
    );

  i_OVF_reg : GENERIC_DFF
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
    )
    port map (
        async_cond => OPEN
      , async_val => OPEN
      , clk  => CLK
      , d    => OVF_INT_R
      , le   => OPEN
      , q    => OVF
      , rst  => OPEN
    );

  i_FIR_CELL_0_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000010001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_0
      , A2   => global_1
      , A3   => global_1
      , A4   => global_1
      , A5   => global_1
      , A6   => global_1
      , A7   => global_1
      , A8   => global_1
      , A9   => global_1
      , A10  => global_1
      , A11  => global_1
      , A12  => global_1
      , A13  => global_1
      , A14  => global_1
      , A15  => global_1
      , A16  => global_1
      , A17  => global_1
      , A18  => global_1
      , A19  => global_1
      , A20  => global_1
      , A21  => global_1
      , A22  => global_1
      , A23  => global_1
      , A24  => global_1
      , B1   => DIN_R2(0)
      , B2   => DIN_R2(1)
      , B3   => DIN_R2(2)
      , B4   => DIN_R2(3)
      , B5   => DIN_R2(4)
      , B6   => DIN_R2(5)
      , B7   => DIN_R2(6)
      , B8   => DIN_R2(7)
      , B9   => DIN_R2(8)
      , B10  => DIN_R2(9)
      , B11  => DIN_R2(10)
      , B12  => DIN_R2(11)
      , B13  => DIN_R2(12)
      , B14  => DIN_R2(13)
      , B15  => DIN_R2(14)
      , B16  => DIN_R2(15)
      , B17  => DIN_R2(15)
      , B18  => DIN_R2(15)
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_1
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => global_0
      , CBI2 => global_0
      , CBI3 => global_0
      , CBI4 => global_0
      , CBI5 => global_0
      , CBI6 => global_0
      , CBI7 => global_0
      , CBI8 => global_0
      , CBI9 => global_0
      , CBI10 => global_0
      , CBI11 => global_0
      , CBI12 => global_0
      , CBI13 => global_0
      , CBI14 => global_0
      , CBI15 => global_0
      , CBI16 => global_0
      , CBI17 => global_0
      , CBI18 => global_0
      , CBO1 => FIR_CASC_B_0(0)
      , CBO2 => FIR_CASC_B_0(1)
      , CBO3 => FIR_CASC_B_0(2)
      , CBO4 => FIR_CASC_B_0(3)
      , CBO5 => FIR_CASC_B_0(4)
      , CBO6 => FIR_CASC_B_0(5)
      , CBO7 => FIR_CASC_B_0(6)
      , CBO8 => FIR_CASC_B_0(7)
      , CBO9 => FIR_CASC_B_0(8)
      , CBO10 => FIR_CASC_B_0(9)
      , CBO11 => FIR_CASC_B_0(10)
      , CBO12 => FIR_CASC_B_0(11)
      , CBO13 => FIR_CASC_B_0(12)
      , CBO14 => FIR_CASC_B_0(13)
      , CBO15 => FIR_CASC_B_0(14)
      , CBO16 => FIR_CASC_B_0(15)
      , CBO17 => FIR_CASC_B_0(16)
      , CBO18 => FIR_CASC_B_0(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => OPEN
      , CZI2 => OPEN
      , CZI3 => OPEN
      , CZI4 => OPEN
      , CZI5 => OPEN
      , CZI6 => OPEN
      , CZI7 => OPEN
      , CZI8 => OPEN
      , CZI9 => OPEN
      , CZI10 => OPEN
      , CZI11 => OPEN
      , CZI12 => OPEN
      , CZI13 => OPEN
      , CZI14 => OPEN
      , CZI15 => OPEN
      , CZI16 => OPEN
      , CZI17 => OPEN
      , CZI18 => OPEN
      , CZI19 => OPEN
      , CZI20 => OPEN
      , CZI21 => OPEN
      , CZI22 => OPEN
      , CZI23 => OPEN
      , CZI24 => OPEN
      , CZI25 => OPEN
      , CZI26 => OPEN
      , CZI27 => OPEN
      , CZI28 => OPEN
      , CZI29 => OPEN
      , CZI30 => OPEN
      , CZI31 => OPEN
      , CZI32 => OPEN
      , CZI33 => OPEN
      , CZI34 => OPEN
      , CZI35 => OPEN
      , CZI36 => OPEN
      , CZI37 => OPEN
      , CZI38 => OPEN
      , CZI39 => OPEN
      , CZI40 => OPEN
      , CZI41 => OPEN
      , CZI42 => OPEN
      , CZI43 => OPEN
      , CZI44 => OPEN
      , CZI45 => OPEN
      , CZI46 => OPEN
      , CZI47 => OPEN
      , CZI48 => OPEN
      , CZI49 => OPEN
      , CZI50 => OPEN
      , CZI51 => OPEN
      , CZI52 => OPEN
      , CZI53 => OPEN
      , CZI54 => OPEN
      , CZI55 => OPEN
      , CZI56 => OPEN
      , CZO1 => FIR_CASC_Z_0(0)
      , CZO2 => FIR_CASC_Z_0(1)
      , CZO3 => FIR_CASC_Z_0(2)
      , CZO4 => FIR_CASC_Z_0(3)
      , CZO5 => FIR_CASC_Z_0(4)
      , CZO6 => FIR_CASC_Z_0(5)
      , CZO7 => FIR_CASC_Z_0(6)
      , CZO8 => FIR_CASC_Z_0(7)
      , CZO9 => FIR_CASC_Z_0(8)
      , CZO10 => FIR_CASC_Z_0(9)
      , CZO11 => FIR_CASC_Z_0(10)
      , CZO12 => FIR_CASC_Z_0(11)
      , CZO13 => FIR_CASC_Z_0(12)
      , CZO14 => FIR_CASC_Z_0(13)
      , CZO15 => FIR_CASC_Z_0(14)
      , CZO16 => FIR_CASC_Z_0(15)
      , CZO17 => FIR_CASC_Z_0(16)
      , CZO18 => FIR_CASC_Z_0(17)
      , CZO19 => FIR_CASC_Z_0(18)
      , CZO20 => FIR_CASC_Z_0(19)
      , CZO21 => FIR_CASC_Z_0(20)
      , CZO22 => FIR_CASC_Z_0(21)
      , CZO23 => FIR_CASC_Z_0(22)
      , CZO24 => FIR_CASC_Z_0(23)
      , CZO25 => FIR_CASC_Z_0(24)
      , CZO26 => FIR_CASC_Z_0(25)
      , CZO27 => FIR_CASC_Z_0(26)
      , CZO28 => FIR_CASC_Z_0(27)
      , CZO29 => FIR_CASC_Z_0(28)
      , CZO30 => FIR_CASC_Z_0(29)
      , CZO31 => FIR_CASC_Z_0(30)
      , CZO32 => FIR_CASC_Z_0(31)
      , CZO33 => FIR_CASC_Z_0(32)
      , CZO34 => FIR_CASC_Z_0(33)
      , CZO35 => FIR_CASC_Z_0(34)
      , CZO36 => FIR_CASC_Z_0(35)
      , CZO37 => FIR_CASC_Z_0(36)
      , CZO38 => FIR_CASC_Z_0(37)
      , CZO39 => FIR_CASC_Z_0(38)
      , CZO40 => FIR_CASC_Z_0(39)
      , CZO41 => FIR_CASC_Z_0(40)
      , CZO42 => FIR_CASC_Z_0(41)
      , CZO43 => FIR_CASC_Z_0(42)
      , CZO44 => FIR_CASC_Z_0(43)
      , CZO45 => FIR_CASC_Z_0(44)
      , CZO46 => FIR_CASC_Z_0(45)
      , CZO47 => FIR_CASC_Z_0(46)
      , CZO48 => FIR_CASC_Z_0(47)
      , CZO49 => FIR_CASC_Z_0(48)
      , CZO50 => FIR_CASC_Z_0(49)
      , CZO51 => FIR_CASC_Z_0(50)
      , CZO52 => FIR_CASC_Z_0(51)
      , CZO53 => FIR_CASC_Z_0(52)
      , CZO54 => FIR_CASC_Z_0(53)
      , CZO55 => FIR_CASC_Z_0(54)
      , CZO56 => FIR_CASC_Z_0(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_CELL_N_M1_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00011101100000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_0
      , A2   => global_1
      , A3   => global_1
      , A4   => global_1
      , A5   => global_1
      , A6   => global_1
      , A7   => global_1
      , A8   => global_1
      , A9   => global_1
      , A10  => global_1
      , A11  => global_1
      , A12  => global_1
      , A13  => global_1
      , A14  => global_1
      , A15  => global_1
      , A16  => global_1
      , A17  => global_1
      , A18  => global_1
      , A19  => global_1
      , A20  => global_1
      , A21  => global_1
      , A22  => global_1
      , A23  => global_1
      , A24  => global_1
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_12(0)
      , CBI2 => FIR_CASC_B_12(1)
      , CBI3 => FIR_CASC_B_12(2)
      , CBI4 => FIR_CASC_B_12(3)
      , CBI5 => FIR_CASC_B_12(4)
      , CBI6 => FIR_CASC_B_12(5)
      , CBI7 => FIR_CASC_B_12(6)
      , CBI8 => FIR_CASC_B_12(7)
      , CBI9 => FIR_CASC_B_12(8)
      , CBI10 => FIR_CASC_B_12(9)
      , CBI11 => FIR_CASC_B_12(10)
      , CBI12 => FIR_CASC_B_12(11)
      , CBI13 => FIR_CASC_B_12(12)
      , CBI14 => FIR_CASC_B_12(13)
      , CBI15 => FIR_CASC_B_12(14)
      , CBI16 => FIR_CASC_B_12(15)
      , CBI17 => FIR_CASC_B_12(16)
      , CBI18 => FIR_CASC_B_12(17)
      , CBO1 => OPEN
      , CBO2 => OPEN
      , CBO3 => OPEN
      , CBO4 => OPEN
      , CBO5 => OPEN
      , CBO6 => OPEN
      , CBO7 => OPEN
      , CBO8 => OPEN
      , CBO9 => OPEN
      , CBO10 => OPEN
      , CBO11 => OPEN
      , CBO12 => OPEN
      , CBO13 => OPEN
      , CBO14 => OPEN
      , CBO15 => OPEN
      , CBO16 => OPEN
      , CBO17 => OPEN
      , CBO18 => OPEN
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_12(0)
      , CZI2 => FIR_CASC_Z_12(1)
      , CZI3 => FIR_CASC_Z_12(2)
      , CZI4 => FIR_CASC_Z_12(3)
      , CZI5 => FIR_CASC_Z_12(4)
      , CZI6 => FIR_CASC_Z_12(5)
      , CZI7 => FIR_CASC_Z_12(6)
      , CZI8 => FIR_CASC_Z_12(7)
      , CZI9 => FIR_CASC_Z_12(8)
      , CZI10 => FIR_CASC_Z_12(9)
      , CZI11 => FIR_CASC_Z_12(10)
      , CZI12 => FIR_CASC_Z_12(11)
      , CZI13 => FIR_CASC_Z_12(12)
      , CZI14 => FIR_CASC_Z_12(13)
      , CZI15 => FIR_CASC_Z_12(14)
      , CZI16 => FIR_CASC_Z_12(15)
      , CZI17 => FIR_CASC_Z_12(16)
      , CZI18 => FIR_CASC_Z_12(17)
      , CZI19 => FIR_CASC_Z_12(18)
      , CZI20 => FIR_CASC_Z_12(19)
      , CZI21 => FIR_CASC_Z_12(20)
      , CZI22 => FIR_CASC_Z_12(21)
      , CZI23 => FIR_CASC_Z_12(22)
      , CZI24 => FIR_CASC_Z_12(23)
      , CZI25 => FIR_CASC_Z_12(24)
      , CZI26 => FIR_CASC_Z_12(25)
      , CZI27 => FIR_CASC_Z_12(26)
      , CZI28 => FIR_CASC_Z_12(27)
      , CZI29 => FIR_CASC_Z_12(28)
      , CZI30 => FIR_CASC_Z_12(29)
      , CZI31 => FIR_CASC_Z_12(30)
      , CZI32 => FIR_CASC_Z_12(31)
      , CZI33 => FIR_CASC_Z_12(32)
      , CZI34 => FIR_CASC_Z_12(33)
      , CZI35 => FIR_CASC_Z_12(34)
      , CZI36 => FIR_CASC_Z_12(35)
      , CZI37 => FIR_CASC_Z_12(36)
      , CZI38 => FIR_CASC_Z_12(37)
      , CZI39 => FIR_CASC_Z_12(38)
      , CZI40 => FIR_CASC_Z_12(39)
      , CZI41 => FIR_CASC_Z_12(40)
      , CZI42 => FIR_CASC_Z_12(41)
      , CZI43 => FIR_CASC_Z_12(42)
      , CZI44 => FIR_CASC_Z_12(43)
      , CZI45 => FIR_CASC_Z_12(44)
      , CZI46 => FIR_CASC_Z_12(45)
      , CZI47 => FIR_CASC_Z_12(46)
      , CZI48 => FIR_CASC_Z_12(47)
      , CZI49 => FIR_CASC_Z_12(48)
      , CZI50 => FIR_CASC_Z_12(49)
      , CZI51 => FIR_CASC_Z_12(50)
      , CZI52 => FIR_CASC_Z_12(51)
      , CZI53 => FIR_CASC_Z_12(52)
      , CZI54 => FIR_CASC_Z_12(53)
      , CZI55 => FIR_CASC_Z_12(54)
      , CZI56 => FIR_CASC_Z_12(55)
      , CZO1 => OPEN
      , CZO2 => OPEN
      , CZO3 => OPEN
      , CZO4 => OPEN
      , CZO5 => OPEN
      , CZO6 => OPEN
      , CZO7 => OPEN
      , CZO8 => OPEN
      , CZO9 => OPEN
      , CZO10 => OPEN
      , CZO11 => OPEN
      , CZO12 => OPEN
      , CZO13 => OPEN
      , CZO14 => OPEN
      , CZO15 => OPEN
      , CZO16 => OPEN
      , CZO17 => OPEN
      , CZO18 => OPEN
      , CZO19 => OPEN
      , CZO20 => OPEN
      , CZO21 => OPEN
      , CZO22 => OPEN
      , CZO23 => OPEN
      , CZO24 => OPEN
      , CZO25 => OPEN
      , CZO26 => OPEN
      , CZO27 => OPEN
      , CZO28 => OPEN
      , CZO29 => OPEN
      , CZO30 => OPEN
      , CZO31 => OPEN
      , CZO32 => OPEN
      , CZO33 => OPEN
      , CZO34 => OPEN
      , CZO35 => OPEN
      , CZO36 => OPEN
      , CZO37 => OPEN
      , CZO38 => OPEN
      , CZO39 => OPEN
      , CZO40 => OPEN
      , CZO41 => OPEN
      , CZO42 => OPEN
      , CZO43 => OPEN
      , CZO44 => OPEN
      , CZO45 => OPEN
      , CZO46 => OPEN
      , CZO47 => OPEN
      , CZO48 => OPEN
      , CZO49 => OPEN
      , CZO50 => OPEN
      , CZO51 => OPEN
      , CZO52 => OPEN
      , CZO53 => OPEN
      , CZO54 => OPEN
      , CZO55 => OPEN
      , CZO56 => OPEN
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OVF_INT
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => FIR_OUT(14)
      , Z16  => FIR_OUT(15)
      , Z17  => FIR_OUT(16)
      , Z18  => FIR_OUT(17)
      , Z19  => FIR_OUT(18)
      , Z20  => FIR_OUT(19)
      , Z21  => FIR_OUT(20)
      , Z22  => FIR_OUT(21)
      , Z23  => FIR_OUT(22)
      , Z24  => FIR_OUT(23)
      , Z25  => FIR_OUT(24)
      , Z26  => FIR_OUT(25)
      , Z27  => FIR_OUT(26)
      , Z28  => FIR_OUT(27)
      , Z29  => FIR_OUT(28)
      , Z30  => FIR_OUT(29)
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_1_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_0
      , A2   => global_1
      , A3   => global_1
      , A4   => global_1
      , A5   => global_0
      , A6   => global_1
      , A7   => global_1
      , A8   => global_0
      , A9   => global_1
      , A10  => global_1
      , A11  => global_1
      , A12  => global_1
      , A13  => global_1
      , A14  => global_1
      , A15  => global_1
      , A16  => global_1
      , A17  => global_1
      , A18  => global_1
      , A19  => global_1
      , A20  => global_1
      , A21  => global_1
      , A22  => global_1
      , A23  => global_1
      , A24  => global_1
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_0(0)
      , CBI2 => FIR_CASC_B_0(1)
      , CBI3 => FIR_CASC_B_0(2)
      , CBI4 => FIR_CASC_B_0(3)
      , CBI5 => FIR_CASC_B_0(4)
      , CBI6 => FIR_CASC_B_0(5)
      , CBI7 => FIR_CASC_B_0(6)
      , CBI8 => FIR_CASC_B_0(7)
      , CBI9 => FIR_CASC_B_0(8)
      , CBI10 => FIR_CASC_B_0(9)
      , CBI11 => FIR_CASC_B_0(10)
      , CBI12 => FIR_CASC_B_0(11)
      , CBI13 => FIR_CASC_B_0(12)
      , CBI14 => FIR_CASC_B_0(13)
      , CBI15 => FIR_CASC_B_0(14)
      , CBI16 => FIR_CASC_B_0(15)
      , CBI17 => FIR_CASC_B_0(16)
      , CBI18 => FIR_CASC_B_0(17)
      , CBO1 => FIR_CASC_B_1(0)
      , CBO2 => FIR_CASC_B_1(1)
      , CBO3 => FIR_CASC_B_1(2)
      , CBO4 => FIR_CASC_B_1(3)
      , CBO5 => FIR_CASC_B_1(4)
      , CBO6 => FIR_CASC_B_1(5)
      , CBO7 => FIR_CASC_B_1(6)
      , CBO8 => FIR_CASC_B_1(7)
      , CBO9 => FIR_CASC_B_1(8)
      , CBO10 => FIR_CASC_B_1(9)
      , CBO11 => FIR_CASC_B_1(10)
      , CBO12 => FIR_CASC_B_1(11)
      , CBO13 => FIR_CASC_B_1(12)
      , CBO14 => FIR_CASC_B_1(13)
      , CBO15 => FIR_CASC_B_1(14)
      , CBO16 => FIR_CASC_B_1(15)
      , CBO17 => FIR_CASC_B_1(16)
      , CBO18 => FIR_CASC_B_1(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_0(0)
      , CZI2 => FIR_CASC_Z_0(1)
      , CZI3 => FIR_CASC_Z_0(2)
      , CZI4 => FIR_CASC_Z_0(3)
      , CZI5 => FIR_CASC_Z_0(4)
      , CZI6 => FIR_CASC_Z_0(5)
      , CZI7 => FIR_CASC_Z_0(6)
      , CZI8 => FIR_CASC_Z_0(7)
      , CZI9 => FIR_CASC_Z_0(8)
      , CZI10 => FIR_CASC_Z_0(9)
      , CZI11 => FIR_CASC_Z_0(10)
      , CZI12 => FIR_CASC_Z_0(11)
      , CZI13 => FIR_CASC_Z_0(12)
      , CZI14 => FIR_CASC_Z_0(13)
      , CZI15 => FIR_CASC_Z_0(14)
      , CZI16 => FIR_CASC_Z_0(15)
      , CZI17 => FIR_CASC_Z_0(16)
      , CZI18 => FIR_CASC_Z_0(17)
      , CZI19 => FIR_CASC_Z_0(18)
      , CZI20 => FIR_CASC_Z_0(19)
      , CZI21 => FIR_CASC_Z_0(20)
      , CZI22 => FIR_CASC_Z_0(21)
      , CZI23 => FIR_CASC_Z_0(22)
      , CZI24 => FIR_CASC_Z_0(23)
      , CZI25 => FIR_CASC_Z_0(24)
      , CZI26 => FIR_CASC_Z_0(25)
      , CZI27 => FIR_CASC_Z_0(26)
      , CZI28 => FIR_CASC_Z_0(27)
      , CZI29 => FIR_CASC_Z_0(28)
      , CZI30 => FIR_CASC_Z_0(29)
      , CZI31 => FIR_CASC_Z_0(30)
      , CZI32 => FIR_CASC_Z_0(31)
      , CZI33 => FIR_CASC_Z_0(32)
      , CZI34 => FIR_CASC_Z_0(33)
      , CZI35 => FIR_CASC_Z_0(34)
      , CZI36 => FIR_CASC_Z_0(35)
      , CZI37 => FIR_CASC_Z_0(36)
      , CZI38 => FIR_CASC_Z_0(37)
      , CZI39 => FIR_CASC_Z_0(38)
      , CZI40 => FIR_CASC_Z_0(39)
      , CZI41 => FIR_CASC_Z_0(40)
      , CZI42 => FIR_CASC_Z_0(41)
      , CZI43 => FIR_CASC_Z_0(42)
      , CZI44 => FIR_CASC_Z_0(43)
      , CZI45 => FIR_CASC_Z_0(44)
      , CZI46 => FIR_CASC_Z_0(45)
      , CZI47 => FIR_CASC_Z_0(46)
      , CZI48 => FIR_CASC_Z_0(47)
      , CZI49 => FIR_CASC_Z_0(48)
      , CZI50 => FIR_CASC_Z_0(49)
      , CZI51 => FIR_CASC_Z_0(50)
      , CZI52 => FIR_CASC_Z_0(51)
      , CZI53 => FIR_CASC_Z_0(52)
      , CZI54 => FIR_CASC_Z_0(53)
      , CZI55 => FIR_CASC_Z_0(54)
      , CZI56 => FIR_CASC_Z_0(55)
      , CZO1 => FIR_CASC_Z_1(0)
      , CZO2 => FIR_CASC_Z_1(1)
      , CZO3 => FIR_CASC_Z_1(2)
      , CZO4 => FIR_CASC_Z_1(3)
      , CZO5 => FIR_CASC_Z_1(4)
      , CZO6 => FIR_CASC_Z_1(5)
      , CZO7 => FIR_CASC_Z_1(6)
      , CZO8 => FIR_CASC_Z_1(7)
      , CZO9 => FIR_CASC_Z_1(8)
      , CZO10 => FIR_CASC_Z_1(9)
      , CZO11 => FIR_CASC_Z_1(10)
      , CZO12 => FIR_CASC_Z_1(11)
      , CZO13 => FIR_CASC_Z_1(12)
      , CZO14 => FIR_CASC_Z_1(13)
      , CZO15 => FIR_CASC_Z_1(14)
      , CZO16 => FIR_CASC_Z_1(15)
      , CZO17 => FIR_CASC_Z_1(16)
      , CZO18 => FIR_CASC_Z_1(17)
      , CZO19 => FIR_CASC_Z_1(18)
      , CZO20 => FIR_CASC_Z_1(19)
      , CZO21 => FIR_CASC_Z_1(20)
      , CZO22 => FIR_CASC_Z_1(21)
      , CZO23 => FIR_CASC_Z_1(22)
      , CZO24 => FIR_CASC_Z_1(23)
      , CZO25 => FIR_CASC_Z_1(24)
      , CZO26 => FIR_CASC_Z_1(25)
      , CZO27 => FIR_CASC_Z_1(26)
      , CZO28 => FIR_CASC_Z_1(27)
      , CZO29 => FIR_CASC_Z_1(28)
      , CZO30 => FIR_CASC_Z_1(29)
      , CZO31 => FIR_CASC_Z_1(30)
      , CZO32 => FIR_CASC_Z_1(31)
      , CZO33 => FIR_CASC_Z_1(32)
      , CZO34 => FIR_CASC_Z_1(33)
      , CZO35 => FIR_CASC_Z_1(34)
      , CZO36 => FIR_CASC_Z_1(35)
      , CZO37 => FIR_CASC_Z_1(36)
      , CZO38 => FIR_CASC_Z_1(37)
      , CZO39 => FIR_CASC_Z_1(38)
      , CZO40 => FIR_CASC_Z_1(39)
      , CZO41 => FIR_CASC_Z_1(40)
      , CZO42 => FIR_CASC_Z_1(41)
      , CZO43 => FIR_CASC_Z_1(42)
      , CZO44 => FIR_CASC_Z_1(43)
      , CZO45 => FIR_CASC_Z_1(44)
      , CZO46 => FIR_CASC_Z_1(45)
      , CZO47 => FIR_CASC_Z_1(46)
      , CZO48 => FIR_CASC_Z_1(47)
      , CZO49 => FIR_CASC_Z_1(48)
      , CZO50 => FIR_CASC_Z_1(49)
      , CZO51 => FIR_CASC_Z_1(50)
      , CZO52 => FIR_CASC_Z_1(51)
      , CZO53 => FIR_CASC_Z_1(52)
      , CZO54 => FIR_CASC_Z_1(53)
      , CZO55 => FIR_CASC_Z_1(54)
      , CZO56 => FIR_CASC_Z_1(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_2_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_0
      , A2   => global_0
      , A3   => global_1
      , A4   => global_1
      , A5   => global_0
      , A6   => global_1
      , A7   => global_0
      , A8   => global_1
      , A9   => global_1
      , A10  => global_0
      , A11  => global_1
      , A12  => global_1
      , A13  => global_1
      , A14  => global_1
      , A15  => global_1
      , A16  => global_1
      , A17  => global_1
      , A18  => global_1
      , A19  => global_1
      , A20  => global_1
      , A21  => global_1
      , A22  => global_1
      , A23  => global_1
      , A24  => global_1
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_1(0)
      , CBI2 => FIR_CASC_B_1(1)
      , CBI3 => FIR_CASC_B_1(2)
      , CBI4 => FIR_CASC_B_1(3)
      , CBI5 => FIR_CASC_B_1(4)
      , CBI6 => FIR_CASC_B_1(5)
      , CBI7 => FIR_CASC_B_1(6)
      , CBI8 => FIR_CASC_B_1(7)
      , CBI9 => FIR_CASC_B_1(8)
      , CBI10 => FIR_CASC_B_1(9)
      , CBI11 => FIR_CASC_B_1(10)
      , CBI12 => FIR_CASC_B_1(11)
      , CBI13 => FIR_CASC_B_1(12)
      , CBI14 => FIR_CASC_B_1(13)
      , CBI15 => FIR_CASC_B_1(14)
      , CBI16 => FIR_CASC_B_1(15)
      , CBI17 => FIR_CASC_B_1(16)
      , CBI18 => FIR_CASC_B_1(17)
      , CBO1 => FIR_CASC_B_2(0)
      , CBO2 => FIR_CASC_B_2(1)
      , CBO3 => FIR_CASC_B_2(2)
      , CBO4 => FIR_CASC_B_2(3)
      , CBO5 => FIR_CASC_B_2(4)
      , CBO6 => FIR_CASC_B_2(5)
      , CBO7 => FIR_CASC_B_2(6)
      , CBO8 => FIR_CASC_B_2(7)
      , CBO9 => FIR_CASC_B_2(8)
      , CBO10 => FIR_CASC_B_2(9)
      , CBO11 => FIR_CASC_B_2(10)
      , CBO12 => FIR_CASC_B_2(11)
      , CBO13 => FIR_CASC_B_2(12)
      , CBO14 => FIR_CASC_B_2(13)
      , CBO15 => FIR_CASC_B_2(14)
      , CBO16 => FIR_CASC_B_2(15)
      , CBO17 => FIR_CASC_B_2(16)
      , CBO18 => FIR_CASC_B_2(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_1(0)
      , CZI2 => FIR_CASC_Z_1(1)
      , CZI3 => FIR_CASC_Z_1(2)
      , CZI4 => FIR_CASC_Z_1(3)
      , CZI5 => FIR_CASC_Z_1(4)
      , CZI6 => FIR_CASC_Z_1(5)
      , CZI7 => FIR_CASC_Z_1(6)
      , CZI8 => FIR_CASC_Z_1(7)
      , CZI9 => FIR_CASC_Z_1(8)
      , CZI10 => FIR_CASC_Z_1(9)
      , CZI11 => FIR_CASC_Z_1(10)
      , CZI12 => FIR_CASC_Z_1(11)
      , CZI13 => FIR_CASC_Z_1(12)
      , CZI14 => FIR_CASC_Z_1(13)
      , CZI15 => FIR_CASC_Z_1(14)
      , CZI16 => FIR_CASC_Z_1(15)
      , CZI17 => FIR_CASC_Z_1(16)
      , CZI18 => FIR_CASC_Z_1(17)
      , CZI19 => FIR_CASC_Z_1(18)
      , CZI20 => FIR_CASC_Z_1(19)
      , CZI21 => FIR_CASC_Z_1(20)
      , CZI22 => FIR_CASC_Z_1(21)
      , CZI23 => FIR_CASC_Z_1(22)
      , CZI24 => FIR_CASC_Z_1(23)
      , CZI25 => FIR_CASC_Z_1(24)
      , CZI26 => FIR_CASC_Z_1(25)
      , CZI27 => FIR_CASC_Z_1(26)
      , CZI28 => FIR_CASC_Z_1(27)
      , CZI29 => FIR_CASC_Z_1(28)
      , CZI30 => FIR_CASC_Z_1(29)
      , CZI31 => FIR_CASC_Z_1(30)
      , CZI32 => FIR_CASC_Z_1(31)
      , CZI33 => FIR_CASC_Z_1(32)
      , CZI34 => FIR_CASC_Z_1(33)
      , CZI35 => FIR_CASC_Z_1(34)
      , CZI36 => FIR_CASC_Z_1(35)
      , CZI37 => FIR_CASC_Z_1(36)
      , CZI38 => FIR_CASC_Z_1(37)
      , CZI39 => FIR_CASC_Z_1(38)
      , CZI40 => FIR_CASC_Z_1(39)
      , CZI41 => FIR_CASC_Z_1(40)
      , CZI42 => FIR_CASC_Z_1(41)
      , CZI43 => FIR_CASC_Z_1(42)
      , CZI44 => FIR_CASC_Z_1(43)
      , CZI45 => FIR_CASC_Z_1(44)
      , CZI46 => FIR_CASC_Z_1(45)
      , CZI47 => FIR_CASC_Z_1(46)
      , CZI48 => FIR_CASC_Z_1(47)
      , CZI49 => FIR_CASC_Z_1(48)
      , CZI50 => FIR_CASC_Z_1(49)
      , CZI51 => FIR_CASC_Z_1(50)
      , CZI52 => FIR_CASC_Z_1(51)
      , CZI53 => FIR_CASC_Z_1(52)
      , CZI54 => FIR_CASC_Z_1(53)
      , CZI55 => FIR_CASC_Z_1(54)
      , CZI56 => FIR_CASC_Z_1(55)
      , CZO1 => FIR_CASC_Z_2(0)
      , CZO2 => FIR_CASC_Z_2(1)
      , CZO3 => FIR_CASC_Z_2(2)
      , CZO4 => FIR_CASC_Z_2(3)
      , CZO5 => FIR_CASC_Z_2(4)
      , CZO6 => FIR_CASC_Z_2(5)
      , CZO7 => FIR_CASC_Z_2(6)
      , CZO8 => FIR_CASC_Z_2(7)
      , CZO9 => FIR_CASC_Z_2(8)
      , CZO10 => FIR_CASC_Z_2(9)
      , CZO11 => FIR_CASC_Z_2(10)
      , CZO12 => FIR_CASC_Z_2(11)
      , CZO13 => FIR_CASC_Z_2(12)
      , CZO14 => FIR_CASC_Z_2(13)
      , CZO15 => FIR_CASC_Z_2(14)
      , CZO16 => FIR_CASC_Z_2(15)
      , CZO17 => FIR_CASC_Z_2(16)
      , CZO18 => FIR_CASC_Z_2(17)
      , CZO19 => FIR_CASC_Z_2(18)
      , CZO20 => FIR_CASC_Z_2(19)
      , CZO21 => FIR_CASC_Z_2(20)
      , CZO22 => FIR_CASC_Z_2(21)
      , CZO23 => FIR_CASC_Z_2(22)
      , CZO24 => FIR_CASC_Z_2(23)
      , CZO25 => FIR_CASC_Z_2(24)
      , CZO26 => FIR_CASC_Z_2(25)
      , CZO27 => FIR_CASC_Z_2(26)
      , CZO28 => FIR_CASC_Z_2(27)
      , CZO29 => FIR_CASC_Z_2(28)
      , CZO30 => FIR_CASC_Z_2(29)
      , CZO31 => FIR_CASC_Z_2(30)
      , CZO32 => FIR_CASC_Z_2(31)
      , CZO33 => FIR_CASC_Z_2(32)
      , CZO34 => FIR_CASC_Z_2(33)
      , CZO35 => FIR_CASC_Z_2(34)
      , CZO36 => FIR_CASC_Z_2(35)
      , CZO37 => FIR_CASC_Z_2(36)
      , CZO38 => FIR_CASC_Z_2(37)
      , CZO39 => FIR_CASC_Z_2(38)
      , CZO40 => FIR_CASC_Z_2(39)
      , CZO41 => FIR_CASC_Z_2(40)
      , CZO42 => FIR_CASC_Z_2(41)
      , CZO43 => FIR_CASC_Z_2(42)
      , CZO44 => FIR_CASC_Z_2(43)
      , CZO45 => FIR_CASC_Z_2(44)
      , CZO46 => FIR_CASC_Z_2(45)
      , CZO47 => FIR_CASC_Z_2(46)
      , CZO48 => FIR_CASC_Z_2(47)
      , CZO49 => FIR_CASC_Z_2(48)
      , CZO50 => FIR_CASC_Z_2(49)
      , CZO51 => FIR_CASC_Z_2(50)
      , CZO52 => FIR_CASC_Z_2(51)
      , CZO53 => FIR_CASC_Z_2(52)
      , CZO54 => FIR_CASC_Z_2(53)
      , CZO55 => FIR_CASC_Z_2(54)
      , CZO56 => FIR_CASC_Z_2(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_3_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_0
      , A2   => global_0
      , A3   => global_1
      , A4   => global_1
      , A5   => global_1
      , A6   => global_1
      , A7   => global_1
      , A8   => global_0
      , A9   => global_1
      , A10  => global_0
      , A11  => global_1
      , A12  => global_1
      , A13  => global_1
      , A14  => global_1
      , A15  => global_1
      , A16  => global_1
      , A17  => global_1
      , A18  => global_1
      , A19  => global_1
      , A20  => global_1
      , A21  => global_1
      , A22  => global_1
      , A23  => global_1
      , A24  => global_1
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_2(0)
      , CBI2 => FIR_CASC_B_2(1)
      , CBI3 => FIR_CASC_B_2(2)
      , CBI4 => FIR_CASC_B_2(3)
      , CBI5 => FIR_CASC_B_2(4)
      , CBI6 => FIR_CASC_B_2(5)
      , CBI7 => FIR_CASC_B_2(6)
      , CBI8 => FIR_CASC_B_2(7)
      , CBI9 => FIR_CASC_B_2(8)
      , CBI10 => FIR_CASC_B_2(9)
      , CBI11 => FIR_CASC_B_2(10)
      , CBI12 => FIR_CASC_B_2(11)
      , CBI13 => FIR_CASC_B_2(12)
      , CBI14 => FIR_CASC_B_2(13)
      , CBI15 => FIR_CASC_B_2(14)
      , CBI16 => FIR_CASC_B_2(15)
      , CBI17 => FIR_CASC_B_2(16)
      , CBI18 => FIR_CASC_B_2(17)
      , CBO1 => FIR_CASC_B_3(0)
      , CBO2 => FIR_CASC_B_3(1)
      , CBO3 => FIR_CASC_B_3(2)
      , CBO4 => FIR_CASC_B_3(3)
      , CBO5 => FIR_CASC_B_3(4)
      , CBO6 => FIR_CASC_B_3(5)
      , CBO7 => FIR_CASC_B_3(6)
      , CBO8 => FIR_CASC_B_3(7)
      , CBO9 => FIR_CASC_B_3(8)
      , CBO10 => FIR_CASC_B_3(9)
      , CBO11 => FIR_CASC_B_3(10)
      , CBO12 => FIR_CASC_B_3(11)
      , CBO13 => FIR_CASC_B_3(12)
      , CBO14 => FIR_CASC_B_3(13)
      , CBO15 => FIR_CASC_B_3(14)
      , CBO16 => FIR_CASC_B_3(15)
      , CBO17 => FIR_CASC_B_3(16)
      , CBO18 => FIR_CASC_B_3(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_2(0)
      , CZI2 => FIR_CASC_Z_2(1)
      , CZI3 => FIR_CASC_Z_2(2)
      , CZI4 => FIR_CASC_Z_2(3)
      , CZI5 => FIR_CASC_Z_2(4)
      , CZI6 => FIR_CASC_Z_2(5)
      , CZI7 => FIR_CASC_Z_2(6)
      , CZI8 => FIR_CASC_Z_2(7)
      , CZI9 => FIR_CASC_Z_2(8)
      , CZI10 => FIR_CASC_Z_2(9)
      , CZI11 => FIR_CASC_Z_2(10)
      , CZI12 => FIR_CASC_Z_2(11)
      , CZI13 => FIR_CASC_Z_2(12)
      , CZI14 => FIR_CASC_Z_2(13)
      , CZI15 => FIR_CASC_Z_2(14)
      , CZI16 => FIR_CASC_Z_2(15)
      , CZI17 => FIR_CASC_Z_2(16)
      , CZI18 => FIR_CASC_Z_2(17)
      , CZI19 => FIR_CASC_Z_2(18)
      , CZI20 => FIR_CASC_Z_2(19)
      , CZI21 => FIR_CASC_Z_2(20)
      , CZI22 => FIR_CASC_Z_2(21)
      , CZI23 => FIR_CASC_Z_2(22)
      , CZI24 => FIR_CASC_Z_2(23)
      , CZI25 => FIR_CASC_Z_2(24)
      , CZI26 => FIR_CASC_Z_2(25)
      , CZI27 => FIR_CASC_Z_2(26)
      , CZI28 => FIR_CASC_Z_2(27)
      , CZI29 => FIR_CASC_Z_2(28)
      , CZI30 => FIR_CASC_Z_2(29)
      , CZI31 => FIR_CASC_Z_2(30)
      , CZI32 => FIR_CASC_Z_2(31)
      , CZI33 => FIR_CASC_Z_2(32)
      , CZI34 => FIR_CASC_Z_2(33)
      , CZI35 => FIR_CASC_Z_2(34)
      , CZI36 => FIR_CASC_Z_2(35)
      , CZI37 => FIR_CASC_Z_2(36)
      , CZI38 => FIR_CASC_Z_2(37)
      , CZI39 => FIR_CASC_Z_2(38)
      , CZI40 => FIR_CASC_Z_2(39)
      , CZI41 => FIR_CASC_Z_2(40)
      , CZI42 => FIR_CASC_Z_2(41)
      , CZI43 => FIR_CASC_Z_2(42)
      , CZI44 => FIR_CASC_Z_2(43)
      , CZI45 => FIR_CASC_Z_2(44)
      , CZI46 => FIR_CASC_Z_2(45)
      , CZI47 => FIR_CASC_Z_2(46)
      , CZI48 => FIR_CASC_Z_2(47)
      , CZI49 => FIR_CASC_Z_2(48)
      , CZI50 => FIR_CASC_Z_2(49)
      , CZI51 => FIR_CASC_Z_2(50)
      , CZI52 => FIR_CASC_Z_2(51)
      , CZI53 => FIR_CASC_Z_2(52)
      , CZI54 => FIR_CASC_Z_2(53)
      , CZI55 => FIR_CASC_Z_2(54)
      , CZI56 => FIR_CASC_Z_2(55)
      , CZO1 => FIR_CASC_Z_3(0)
      , CZO2 => FIR_CASC_Z_3(1)
      , CZO3 => FIR_CASC_Z_3(2)
      , CZO4 => FIR_CASC_Z_3(3)
      , CZO5 => FIR_CASC_Z_3(4)
      , CZO6 => FIR_CASC_Z_3(5)
      , CZO7 => FIR_CASC_Z_3(6)
      , CZO8 => FIR_CASC_Z_3(7)
      , CZO9 => FIR_CASC_Z_3(8)
      , CZO10 => FIR_CASC_Z_3(9)
      , CZO11 => FIR_CASC_Z_3(10)
      , CZO12 => FIR_CASC_Z_3(11)
      , CZO13 => FIR_CASC_Z_3(12)
      , CZO14 => FIR_CASC_Z_3(13)
      , CZO15 => FIR_CASC_Z_3(14)
      , CZO16 => FIR_CASC_Z_3(15)
      , CZO17 => FIR_CASC_Z_3(16)
      , CZO18 => FIR_CASC_Z_3(17)
      , CZO19 => FIR_CASC_Z_3(18)
      , CZO20 => FIR_CASC_Z_3(19)
      , CZO21 => FIR_CASC_Z_3(20)
      , CZO22 => FIR_CASC_Z_3(21)
      , CZO23 => FIR_CASC_Z_3(22)
      , CZO24 => FIR_CASC_Z_3(23)
      , CZO25 => FIR_CASC_Z_3(24)
      , CZO26 => FIR_CASC_Z_3(25)
      , CZO27 => FIR_CASC_Z_3(26)
      , CZO28 => FIR_CASC_Z_3(27)
      , CZO29 => FIR_CASC_Z_3(28)
      , CZO30 => FIR_CASC_Z_3(29)
      , CZO31 => FIR_CASC_Z_3(30)
      , CZO32 => FIR_CASC_Z_3(31)
      , CZO33 => FIR_CASC_Z_3(32)
      , CZO34 => FIR_CASC_Z_3(33)
      , CZO35 => FIR_CASC_Z_3(34)
      , CZO36 => FIR_CASC_Z_3(35)
      , CZO37 => FIR_CASC_Z_3(36)
      , CZO38 => FIR_CASC_Z_3(37)
      , CZO39 => FIR_CASC_Z_3(38)
      , CZO40 => FIR_CASC_Z_3(39)
      , CZO41 => FIR_CASC_Z_3(40)
      , CZO42 => FIR_CASC_Z_3(41)
      , CZO43 => FIR_CASC_Z_3(42)
      , CZO44 => FIR_CASC_Z_3(43)
      , CZO45 => FIR_CASC_Z_3(44)
      , CZO46 => FIR_CASC_Z_3(45)
      , CZO47 => FIR_CASC_Z_3(46)
      , CZO48 => FIR_CASC_Z_3(47)
      , CZO49 => FIR_CASC_Z_3(48)
      , CZO50 => FIR_CASC_Z_3(49)
      , CZO51 => FIR_CASC_Z_3(50)
      , CZO52 => FIR_CASC_Z_3(51)
      , CZO53 => FIR_CASC_Z_3(52)
      , CZO54 => FIR_CASC_Z_3(53)
      , CZO55 => FIR_CASC_Z_3(54)
      , CZO56 => FIR_CASC_Z_3(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_4_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_1
      , A2   => global_1
      , A3   => global_1
      , A4   => global_0
      , A5   => global_1
      , A6   => global_0
      , A7   => global_0
      , A8   => global_0
      , A9   => global_0
      , A10  => global_1
      , A11  => global_0
      , A12  => global_0
      , A13  => global_0
      , A14  => global_0
      , A15  => global_0
      , A16  => global_0
      , A17  => global_0
      , A18  => global_0
      , A19  => global_0
      , A20  => global_0
      , A21  => global_0
      , A22  => global_0
      , A23  => global_0
      , A24  => global_0
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_3(0)
      , CBI2 => FIR_CASC_B_3(1)
      , CBI3 => FIR_CASC_B_3(2)
      , CBI4 => FIR_CASC_B_3(3)
      , CBI5 => FIR_CASC_B_3(4)
      , CBI6 => FIR_CASC_B_3(5)
      , CBI7 => FIR_CASC_B_3(6)
      , CBI8 => FIR_CASC_B_3(7)
      , CBI9 => FIR_CASC_B_3(8)
      , CBI10 => FIR_CASC_B_3(9)
      , CBI11 => FIR_CASC_B_3(10)
      , CBI12 => FIR_CASC_B_3(11)
      , CBI13 => FIR_CASC_B_3(12)
      , CBI14 => FIR_CASC_B_3(13)
      , CBI15 => FIR_CASC_B_3(14)
      , CBI16 => FIR_CASC_B_3(15)
      , CBI17 => FIR_CASC_B_3(16)
      , CBI18 => FIR_CASC_B_3(17)
      , CBO1 => FIR_CASC_B_4(0)
      , CBO2 => FIR_CASC_B_4(1)
      , CBO3 => FIR_CASC_B_4(2)
      , CBO4 => FIR_CASC_B_4(3)
      , CBO5 => FIR_CASC_B_4(4)
      , CBO6 => FIR_CASC_B_4(5)
      , CBO7 => FIR_CASC_B_4(6)
      , CBO8 => FIR_CASC_B_4(7)
      , CBO9 => FIR_CASC_B_4(8)
      , CBO10 => FIR_CASC_B_4(9)
      , CBO11 => FIR_CASC_B_4(10)
      , CBO12 => FIR_CASC_B_4(11)
      , CBO13 => FIR_CASC_B_4(12)
      , CBO14 => FIR_CASC_B_4(13)
      , CBO15 => FIR_CASC_B_4(14)
      , CBO16 => FIR_CASC_B_4(15)
      , CBO17 => FIR_CASC_B_4(16)
      , CBO18 => FIR_CASC_B_4(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_3(0)
      , CZI2 => FIR_CASC_Z_3(1)
      , CZI3 => FIR_CASC_Z_3(2)
      , CZI4 => FIR_CASC_Z_3(3)
      , CZI5 => FIR_CASC_Z_3(4)
      , CZI6 => FIR_CASC_Z_3(5)
      , CZI7 => FIR_CASC_Z_3(6)
      , CZI8 => FIR_CASC_Z_3(7)
      , CZI9 => FIR_CASC_Z_3(8)
      , CZI10 => FIR_CASC_Z_3(9)
      , CZI11 => FIR_CASC_Z_3(10)
      , CZI12 => FIR_CASC_Z_3(11)
      , CZI13 => FIR_CASC_Z_3(12)
      , CZI14 => FIR_CASC_Z_3(13)
      , CZI15 => FIR_CASC_Z_3(14)
      , CZI16 => FIR_CASC_Z_3(15)
      , CZI17 => FIR_CASC_Z_3(16)
      , CZI18 => FIR_CASC_Z_3(17)
      , CZI19 => FIR_CASC_Z_3(18)
      , CZI20 => FIR_CASC_Z_3(19)
      , CZI21 => FIR_CASC_Z_3(20)
      , CZI22 => FIR_CASC_Z_3(21)
      , CZI23 => FIR_CASC_Z_3(22)
      , CZI24 => FIR_CASC_Z_3(23)
      , CZI25 => FIR_CASC_Z_3(24)
      , CZI26 => FIR_CASC_Z_3(25)
      , CZI27 => FIR_CASC_Z_3(26)
      , CZI28 => FIR_CASC_Z_3(27)
      , CZI29 => FIR_CASC_Z_3(28)
      , CZI30 => FIR_CASC_Z_3(29)
      , CZI31 => FIR_CASC_Z_3(30)
      , CZI32 => FIR_CASC_Z_3(31)
      , CZI33 => FIR_CASC_Z_3(32)
      , CZI34 => FIR_CASC_Z_3(33)
      , CZI35 => FIR_CASC_Z_3(34)
      , CZI36 => FIR_CASC_Z_3(35)
      , CZI37 => FIR_CASC_Z_3(36)
      , CZI38 => FIR_CASC_Z_3(37)
      , CZI39 => FIR_CASC_Z_3(38)
      , CZI40 => FIR_CASC_Z_3(39)
      , CZI41 => FIR_CASC_Z_3(40)
      , CZI42 => FIR_CASC_Z_3(41)
      , CZI43 => FIR_CASC_Z_3(42)
      , CZI44 => FIR_CASC_Z_3(43)
      , CZI45 => FIR_CASC_Z_3(44)
      , CZI46 => FIR_CASC_Z_3(45)
      , CZI47 => FIR_CASC_Z_3(46)
      , CZI48 => FIR_CASC_Z_3(47)
      , CZI49 => FIR_CASC_Z_3(48)
      , CZI50 => FIR_CASC_Z_3(49)
      , CZI51 => FIR_CASC_Z_3(50)
      , CZI52 => FIR_CASC_Z_3(51)
      , CZI53 => FIR_CASC_Z_3(52)
      , CZI54 => FIR_CASC_Z_3(53)
      , CZI55 => FIR_CASC_Z_3(54)
      , CZI56 => FIR_CASC_Z_3(55)
      , CZO1 => FIR_CASC_Z_4(0)
      , CZO2 => FIR_CASC_Z_4(1)
      , CZO3 => FIR_CASC_Z_4(2)
      , CZO4 => FIR_CASC_Z_4(3)
      , CZO5 => FIR_CASC_Z_4(4)
      , CZO6 => FIR_CASC_Z_4(5)
      , CZO7 => FIR_CASC_Z_4(6)
      , CZO8 => FIR_CASC_Z_4(7)
      , CZO9 => FIR_CASC_Z_4(8)
      , CZO10 => FIR_CASC_Z_4(9)
      , CZO11 => FIR_CASC_Z_4(10)
      , CZO12 => FIR_CASC_Z_4(11)
      , CZO13 => FIR_CASC_Z_4(12)
      , CZO14 => FIR_CASC_Z_4(13)
      , CZO15 => FIR_CASC_Z_4(14)
      , CZO16 => FIR_CASC_Z_4(15)
      , CZO17 => FIR_CASC_Z_4(16)
      , CZO18 => FIR_CASC_Z_4(17)
      , CZO19 => FIR_CASC_Z_4(18)
      , CZO20 => FIR_CASC_Z_4(19)
      , CZO21 => FIR_CASC_Z_4(20)
      , CZO22 => FIR_CASC_Z_4(21)
      , CZO23 => FIR_CASC_Z_4(22)
      , CZO24 => FIR_CASC_Z_4(23)
      , CZO25 => FIR_CASC_Z_4(24)
      , CZO26 => FIR_CASC_Z_4(25)
      , CZO27 => FIR_CASC_Z_4(26)
      , CZO28 => FIR_CASC_Z_4(27)
      , CZO29 => FIR_CASC_Z_4(28)
      , CZO30 => FIR_CASC_Z_4(29)
      , CZO31 => FIR_CASC_Z_4(30)
      , CZO32 => FIR_CASC_Z_4(31)
      , CZO33 => FIR_CASC_Z_4(32)
      , CZO34 => FIR_CASC_Z_4(33)
      , CZO35 => FIR_CASC_Z_4(34)
      , CZO36 => FIR_CASC_Z_4(35)
      , CZO37 => FIR_CASC_Z_4(36)
      , CZO38 => FIR_CASC_Z_4(37)
      , CZO39 => FIR_CASC_Z_4(38)
      , CZO40 => FIR_CASC_Z_4(39)
      , CZO41 => FIR_CASC_Z_4(40)
      , CZO42 => FIR_CASC_Z_4(41)
      , CZO43 => FIR_CASC_Z_4(42)
      , CZO44 => FIR_CASC_Z_4(43)
      , CZO45 => FIR_CASC_Z_4(44)
      , CZO46 => FIR_CASC_Z_4(45)
      , CZO47 => FIR_CASC_Z_4(46)
      , CZO48 => FIR_CASC_Z_4(47)
      , CZO49 => FIR_CASC_Z_4(48)
      , CZO50 => FIR_CASC_Z_4(49)
      , CZO51 => FIR_CASC_Z_4(50)
      , CZO52 => FIR_CASC_Z_4(51)
      , CZO53 => FIR_CASC_Z_4(52)
      , CZO54 => FIR_CASC_Z_4(53)
      , CZO55 => FIR_CASC_Z_4(54)
      , CZO56 => FIR_CASC_Z_4(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_5_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_1
      , A2   => global_0
      , A3   => global_0
      , A4   => global_0
      , A5   => global_0
      , A6   => global_1
      , A7   => global_0
      , A8   => global_1
      , A9   => global_0
      , A10  => global_1
      , A11  => global_1
      , A12  => global_1
      , A13  => global_0
      , A14  => global_0
      , A15  => global_0
      , A16  => global_0
      , A17  => global_0
      , A18  => global_0
      , A19  => global_0
      , A20  => global_0
      , A21  => global_0
      , A22  => global_0
      , A23  => global_0
      , A24  => global_0
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_4(0)
      , CBI2 => FIR_CASC_B_4(1)
      , CBI3 => FIR_CASC_B_4(2)
      , CBI4 => FIR_CASC_B_4(3)
      , CBI5 => FIR_CASC_B_4(4)
      , CBI6 => FIR_CASC_B_4(5)
      , CBI7 => FIR_CASC_B_4(6)
      , CBI8 => FIR_CASC_B_4(7)
      , CBI9 => FIR_CASC_B_4(8)
      , CBI10 => FIR_CASC_B_4(9)
      , CBI11 => FIR_CASC_B_4(10)
      , CBI12 => FIR_CASC_B_4(11)
      , CBI13 => FIR_CASC_B_4(12)
      , CBI14 => FIR_CASC_B_4(13)
      , CBI15 => FIR_CASC_B_4(14)
      , CBI16 => FIR_CASC_B_4(15)
      , CBI17 => FIR_CASC_B_4(16)
      , CBI18 => FIR_CASC_B_4(17)
      , CBO1 => FIR_CASC_B_5(0)
      , CBO2 => FIR_CASC_B_5(1)
      , CBO3 => FIR_CASC_B_5(2)
      , CBO4 => FIR_CASC_B_5(3)
      , CBO5 => FIR_CASC_B_5(4)
      , CBO6 => FIR_CASC_B_5(5)
      , CBO7 => FIR_CASC_B_5(6)
      , CBO8 => FIR_CASC_B_5(7)
      , CBO9 => FIR_CASC_B_5(8)
      , CBO10 => FIR_CASC_B_5(9)
      , CBO11 => FIR_CASC_B_5(10)
      , CBO12 => FIR_CASC_B_5(11)
      , CBO13 => FIR_CASC_B_5(12)
      , CBO14 => FIR_CASC_B_5(13)
      , CBO15 => FIR_CASC_B_5(14)
      , CBO16 => FIR_CASC_B_5(15)
      , CBO17 => FIR_CASC_B_5(16)
      , CBO18 => FIR_CASC_B_5(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_4(0)
      , CZI2 => FIR_CASC_Z_4(1)
      , CZI3 => FIR_CASC_Z_4(2)
      , CZI4 => FIR_CASC_Z_4(3)
      , CZI5 => FIR_CASC_Z_4(4)
      , CZI6 => FIR_CASC_Z_4(5)
      , CZI7 => FIR_CASC_Z_4(6)
      , CZI8 => FIR_CASC_Z_4(7)
      , CZI9 => FIR_CASC_Z_4(8)
      , CZI10 => FIR_CASC_Z_4(9)
      , CZI11 => FIR_CASC_Z_4(10)
      , CZI12 => FIR_CASC_Z_4(11)
      , CZI13 => FIR_CASC_Z_4(12)
      , CZI14 => FIR_CASC_Z_4(13)
      , CZI15 => FIR_CASC_Z_4(14)
      , CZI16 => FIR_CASC_Z_4(15)
      , CZI17 => FIR_CASC_Z_4(16)
      , CZI18 => FIR_CASC_Z_4(17)
      , CZI19 => FIR_CASC_Z_4(18)
      , CZI20 => FIR_CASC_Z_4(19)
      , CZI21 => FIR_CASC_Z_4(20)
      , CZI22 => FIR_CASC_Z_4(21)
      , CZI23 => FIR_CASC_Z_4(22)
      , CZI24 => FIR_CASC_Z_4(23)
      , CZI25 => FIR_CASC_Z_4(24)
      , CZI26 => FIR_CASC_Z_4(25)
      , CZI27 => FIR_CASC_Z_4(26)
      , CZI28 => FIR_CASC_Z_4(27)
      , CZI29 => FIR_CASC_Z_4(28)
      , CZI30 => FIR_CASC_Z_4(29)
      , CZI31 => FIR_CASC_Z_4(30)
      , CZI32 => FIR_CASC_Z_4(31)
      , CZI33 => FIR_CASC_Z_4(32)
      , CZI34 => FIR_CASC_Z_4(33)
      , CZI35 => FIR_CASC_Z_4(34)
      , CZI36 => FIR_CASC_Z_4(35)
      , CZI37 => FIR_CASC_Z_4(36)
      , CZI38 => FIR_CASC_Z_4(37)
      , CZI39 => FIR_CASC_Z_4(38)
      , CZI40 => FIR_CASC_Z_4(39)
      , CZI41 => FIR_CASC_Z_4(40)
      , CZI42 => FIR_CASC_Z_4(41)
      , CZI43 => FIR_CASC_Z_4(42)
      , CZI44 => FIR_CASC_Z_4(43)
      , CZI45 => FIR_CASC_Z_4(44)
      , CZI46 => FIR_CASC_Z_4(45)
      , CZI47 => FIR_CASC_Z_4(46)
      , CZI48 => FIR_CASC_Z_4(47)
      , CZI49 => FIR_CASC_Z_4(48)
      , CZI50 => FIR_CASC_Z_4(49)
      , CZI51 => FIR_CASC_Z_4(50)
      , CZI52 => FIR_CASC_Z_4(51)
      , CZI53 => FIR_CASC_Z_4(52)
      , CZI54 => FIR_CASC_Z_4(53)
      , CZI55 => FIR_CASC_Z_4(54)
      , CZI56 => FIR_CASC_Z_4(55)
      , CZO1 => FIR_CASC_Z_5(0)
      , CZO2 => FIR_CASC_Z_5(1)
      , CZO3 => FIR_CASC_Z_5(2)
      , CZO4 => FIR_CASC_Z_5(3)
      , CZO5 => FIR_CASC_Z_5(4)
      , CZO6 => FIR_CASC_Z_5(5)
      , CZO7 => FIR_CASC_Z_5(6)
      , CZO8 => FIR_CASC_Z_5(7)
      , CZO9 => FIR_CASC_Z_5(8)
      , CZO10 => FIR_CASC_Z_5(9)
      , CZO11 => FIR_CASC_Z_5(10)
      , CZO12 => FIR_CASC_Z_5(11)
      , CZO13 => FIR_CASC_Z_5(12)
      , CZO14 => FIR_CASC_Z_5(13)
      , CZO15 => FIR_CASC_Z_5(14)
      , CZO16 => FIR_CASC_Z_5(15)
      , CZO17 => FIR_CASC_Z_5(16)
      , CZO18 => FIR_CASC_Z_5(17)
      , CZO19 => FIR_CASC_Z_5(18)
      , CZO20 => FIR_CASC_Z_5(19)
      , CZO21 => FIR_CASC_Z_5(20)
      , CZO22 => FIR_CASC_Z_5(21)
      , CZO23 => FIR_CASC_Z_5(22)
      , CZO24 => FIR_CASC_Z_5(23)
      , CZO25 => FIR_CASC_Z_5(24)
      , CZO26 => FIR_CASC_Z_5(25)
      , CZO27 => FIR_CASC_Z_5(26)
      , CZO28 => FIR_CASC_Z_5(27)
      , CZO29 => FIR_CASC_Z_5(28)
      , CZO30 => FIR_CASC_Z_5(29)
      , CZO31 => FIR_CASC_Z_5(30)
      , CZO32 => FIR_CASC_Z_5(31)
      , CZO33 => FIR_CASC_Z_5(32)
      , CZO34 => FIR_CASC_Z_5(33)
      , CZO35 => FIR_CASC_Z_5(34)
      , CZO36 => FIR_CASC_Z_5(35)
      , CZO37 => FIR_CASC_Z_5(36)
      , CZO38 => FIR_CASC_Z_5(37)
      , CZO39 => FIR_CASC_Z_5(38)
      , CZO40 => FIR_CASC_Z_5(39)
      , CZO41 => FIR_CASC_Z_5(40)
      , CZO42 => FIR_CASC_Z_5(41)
      , CZO43 => FIR_CASC_Z_5(42)
      , CZO44 => FIR_CASC_Z_5(43)
      , CZO45 => FIR_CASC_Z_5(44)
      , CZO46 => FIR_CASC_Z_5(45)
      , CZO47 => FIR_CASC_Z_5(46)
      , CZO48 => FIR_CASC_Z_5(47)
      , CZO49 => FIR_CASC_Z_5(48)
      , CZO50 => FIR_CASC_Z_5(49)
      , CZO51 => FIR_CASC_Z_5(50)
      , CZO52 => FIR_CASC_Z_5(51)
      , CZO53 => FIR_CASC_Z_5(52)
      , CZO54 => FIR_CASC_Z_5(53)
      , CZO55 => FIR_CASC_Z_5(54)
      , CZO56 => FIR_CASC_Z_5(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_6_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_1
      , A2   => global_0
      , A3   => global_1
      , A4   => global_1
      , A5   => global_0
      , A6   => global_1
      , A7   => global_0
      , A8   => global_1
      , A9   => global_1
      , A10  => global_1
      , A11  => global_0
      , A12  => global_0
      , A13  => global_1
      , A14  => global_0
      , A15  => global_0
      , A16  => global_0
      , A17  => global_0
      , A18  => global_0
      , A19  => global_0
      , A20  => global_0
      , A21  => global_0
      , A22  => global_0
      , A23  => global_0
      , A24  => global_0
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_5(0)
      , CBI2 => FIR_CASC_B_5(1)
      , CBI3 => FIR_CASC_B_5(2)
      , CBI4 => FIR_CASC_B_5(3)
      , CBI5 => FIR_CASC_B_5(4)
      , CBI6 => FIR_CASC_B_5(5)
      , CBI7 => FIR_CASC_B_5(6)
      , CBI8 => FIR_CASC_B_5(7)
      , CBI9 => FIR_CASC_B_5(8)
      , CBI10 => FIR_CASC_B_5(9)
      , CBI11 => FIR_CASC_B_5(10)
      , CBI12 => FIR_CASC_B_5(11)
      , CBI13 => FIR_CASC_B_5(12)
      , CBI14 => FIR_CASC_B_5(13)
      , CBI15 => FIR_CASC_B_5(14)
      , CBI16 => FIR_CASC_B_5(15)
      , CBI17 => FIR_CASC_B_5(16)
      , CBI18 => FIR_CASC_B_5(17)
      , CBO1 => FIR_CASC_B_6(0)
      , CBO2 => FIR_CASC_B_6(1)
      , CBO3 => FIR_CASC_B_6(2)
      , CBO4 => FIR_CASC_B_6(3)
      , CBO5 => FIR_CASC_B_6(4)
      , CBO6 => FIR_CASC_B_6(5)
      , CBO7 => FIR_CASC_B_6(6)
      , CBO8 => FIR_CASC_B_6(7)
      , CBO9 => FIR_CASC_B_6(8)
      , CBO10 => FIR_CASC_B_6(9)
      , CBO11 => FIR_CASC_B_6(10)
      , CBO12 => FIR_CASC_B_6(11)
      , CBO13 => FIR_CASC_B_6(12)
      , CBO14 => FIR_CASC_B_6(13)
      , CBO15 => FIR_CASC_B_6(14)
      , CBO16 => FIR_CASC_B_6(15)
      , CBO17 => FIR_CASC_B_6(16)
      , CBO18 => FIR_CASC_B_6(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_5(0)
      , CZI2 => FIR_CASC_Z_5(1)
      , CZI3 => FIR_CASC_Z_5(2)
      , CZI4 => FIR_CASC_Z_5(3)
      , CZI5 => FIR_CASC_Z_5(4)
      , CZI6 => FIR_CASC_Z_5(5)
      , CZI7 => FIR_CASC_Z_5(6)
      , CZI8 => FIR_CASC_Z_5(7)
      , CZI9 => FIR_CASC_Z_5(8)
      , CZI10 => FIR_CASC_Z_5(9)
      , CZI11 => FIR_CASC_Z_5(10)
      , CZI12 => FIR_CASC_Z_5(11)
      , CZI13 => FIR_CASC_Z_5(12)
      , CZI14 => FIR_CASC_Z_5(13)
      , CZI15 => FIR_CASC_Z_5(14)
      , CZI16 => FIR_CASC_Z_5(15)
      , CZI17 => FIR_CASC_Z_5(16)
      , CZI18 => FIR_CASC_Z_5(17)
      , CZI19 => FIR_CASC_Z_5(18)
      , CZI20 => FIR_CASC_Z_5(19)
      , CZI21 => FIR_CASC_Z_5(20)
      , CZI22 => FIR_CASC_Z_5(21)
      , CZI23 => FIR_CASC_Z_5(22)
      , CZI24 => FIR_CASC_Z_5(23)
      , CZI25 => FIR_CASC_Z_5(24)
      , CZI26 => FIR_CASC_Z_5(25)
      , CZI27 => FIR_CASC_Z_5(26)
      , CZI28 => FIR_CASC_Z_5(27)
      , CZI29 => FIR_CASC_Z_5(28)
      , CZI30 => FIR_CASC_Z_5(29)
      , CZI31 => FIR_CASC_Z_5(30)
      , CZI32 => FIR_CASC_Z_5(31)
      , CZI33 => FIR_CASC_Z_5(32)
      , CZI34 => FIR_CASC_Z_5(33)
      , CZI35 => FIR_CASC_Z_5(34)
      , CZI36 => FIR_CASC_Z_5(35)
      , CZI37 => FIR_CASC_Z_5(36)
      , CZI38 => FIR_CASC_Z_5(37)
      , CZI39 => FIR_CASC_Z_5(38)
      , CZI40 => FIR_CASC_Z_5(39)
      , CZI41 => FIR_CASC_Z_5(40)
      , CZI42 => FIR_CASC_Z_5(41)
      , CZI43 => FIR_CASC_Z_5(42)
      , CZI44 => FIR_CASC_Z_5(43)
      , CZI45 => FIR_CASC_Z_5(44)
      , CZI46 => FIR_CASC_Z_5(45)
      , CZI47 => FIR_CASC_Z_5(46)
      , CZI48 => FIR_CASC_Z_5(47)
      , CZI49 => FIR_CASC_Z_5(48)
      , CZI50 => FIR_CASC_Z_5(49)
      , CZI51 => FIR_CASC_Z_5(50)
      , CZI52 => FIR_CASC_Z_5(51)
      , CZI53 => FIR_CASC_Z_5(52)
      , CZI54 => FIR_CASC_Z_5(53)
      , CZI55 => FIR_CASC_Z_5(54)
      , CZI56 => FIR_CASC_Z_5(55)
      , CZO1 => FIR_CASC_Z_6(0)
      , CZO2 => FIR_CASC_Z_6(1)
      , CZO3 => FIR_CASC_Z_6(2)
      , CZO4 => FIR_CASC_Z_6(3)
      , CZO5 => FIR_CASC_Z_6(4)
      , CZO6 => FIR_CASC_Z_6(5)
      , CZO7 => FIR_CASC_Z_6(6)
      , CZO8 => FIR_CASC_Z_6(7)
      , CZO9 => FIR_CASC_Z_6(8)
      , CZO10 => FIR_CASC_Z_6(9)
      , CZO11 => FIR_CASC_Z_6(10)
      , CZO12 => FIR_CASC_Z_6(11)
      , CZO13 => FIR_CASC_Z_6(12)
      , CZO14 => FIR_CASC_Z_6(13)
      , CZO15 => FIR_CASC_Z_6(14)
      , CZO16 => FIR_CASC_Z_6(15)
      , CZO17 => FIR_CASC_Z_6(16)
      , CZO18 => FIR_CASC_Z_6(17)
      , CZO19 => FIR_CASC_Z_6(18)
      , CZO20 => FIR_CASC_Z_6(19)
      , CZO21 => FIR_CASC_Z_6(20)
      , CZO22 => FIR_CASC_Z_6(21)
      , CZO23 => FIR_CASC_Z_6(22)
      , CZO24 => FIR_CASC_Z_6(23)
      , CZO25 => FIR_CASC_Z_6(24)
      , CZO26 => FIR_CASC_Z_6(25)
      , CZO27 => FIR_CASC_Z_6(26)
      , CZO28 => FIR_CASC_Z_6(27)
      , CZO29 => FIR_CASC_Z_6(28)
      , CZO30 => FIR_CASC_Z_6(29)
      , CZO31 => FIR_CASC_Z_6(30)
      , CZO32 => FIR_CASC_Z_6(31)
      , CZO33 => FIR_CASC_Z_6(32)
      , CZO34 => FIR_CASC_Z_6(33)
      , CZO35 => FIR_CASC_Z_6(34)
      , CZO36 => FIR_CASC_Z_6(35)
      , CZO37 => FIR_CASC_Z_6(36)
      , CZO38 => FIR_CASC_Z_6(37)
      , CZO39 => FIR_CASC_Z_6(38)
      , CZO40 => FIR_CASC_Z_6(39)
      , CZO41 => FIR_CASC_Z_6(40)
      , CZO42 => FIR_CASC_Z_6(41)
      , CZO43 => FIR_CASC_Z_6(42)
      , CZO44 => FIR_CASC_Z_6(43)
      , CZO45 => FIR_CASC_Z_6(44)
      , CZO46 => FIR_CASC_Z_6(45)
      , CZO47 => FIR_CASC_Z_6(46)
      , CZO48 => FIR_CASC_Z_6(47)
      , CZO49 => FIR_CASC_Z_6(48)
      , CZO50 => FIR_CASC_Z_6(49)
      , CZO51 => FIR_CASC_Z_6(50)
      , CZO52 => FIR_CASC_Z_6(51)
      , CZO53 => FIR_CASC_Z_6(52)
      , CZO54 => FIR_CASC_Z_6(53)
      , CZO55 => FIR_CASC_Z_6(54)
      , CZO56 => FIR_CASC_Z_6(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_7_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_1
      , A2   => global_0
      , A3   => global_1
      , A4   => global_1
      , A5   => global_0
      , A6   => global_1
      , A7   => global_0
      , A8   => global_1
      , A9   => global_1
      , A10  => global_1
      , A11  => global_0
      , A12  => global_0
      , A13  => global_1
      , A14  => global_0
      , A15  => global_0
      , A16  => global_0
      , A17  => global_0
      , A18  => global_0
      , A19  => global_0
      , A20  => global_0
      , A21  => global_0
      , A22  => global_0
      , A23  => global_0
      , A24  => global_0
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_6(0)
      , CBI2 => FIR_CASC_B_6(1)
      , CBI3 => FIR_CASC_B_6(2)
      , CBI4 => FIR_CASC_B_6(3)
      , CBI5 => FIR_CASC_B_6(4)
      , CBI6 => FIR_CASC_B_6(5)
      , CBI7 => FIR_CASC_B_6(6)
      , CBI8 => FIR_CASC_B_6(7)
      , CBI9 => FIR_CASC_B_6(8)
      , CBI10 => FIR_CASC_B_6(9)
      , CBI11 => FIR_CASC_B_6(10)
      , CBI12 => FIR_CASC_B_6(11)
      , CBI13 => FIR_CASC_B_6(12)
      , CBI14 => FIR_CASC_B_6(13)
      , CBI15 => FIR_CASC_B_6(14)
      , CBI16 => FIR_CASC_B_6(15)
      , CBI17 => FIR_CASC_B_6(16)
      , CBI18 => FIR_CASC_B_6(17)
      , CBO1 => FIR_CASC_B_7(0)
      , CBO2 => FIR_CASC_B_7(1)
      , CBO3 => FIR_CASC_B_7(2)
      , CBO4 => FIR_CASC_B_7(3)
      , CBO5 => FIR_CASC_B_7(4)
      , CBO6 => FIR_CASC_B_7(5)
      , CBO7 => FIR_CASC_B_7(6)
      , CBO8 => FIR_CASC_B_7(7)
      , CBO9 => FIR_CASC_B_7(8)
      , CBO10 => FIR_CASC_B_7(9)
      , CBO11 => FIR_CASC_B_7(10)
      , CBO12 => FIR_CASC_B_7(11)
      , CBO13 => FIR_CASC_B_7(12)
      , CBO14 => FIR_CASC_B_7(13)
      , CBO15 => FIR_CASC_B_7(14)
      , CBO16 => FIR_CASC_B_7(15)
      , CBO17 => FIR_CASC_B_7(16)
      , CBO18 => FIR_CASC_B_7(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_6(0)
      , CZI2 => FIR_CASC_Z_6(1)
      , CZI3 => FIR_CASC_Z_6(2)
      , CZI4 => FIR_CASC_Z_6(3)
      , CZI5 => FIR_CASC_Z_6(4)
      , CZI6 => FIR_CASC_Z_6(5)
      , CZI7 => FIR_CASC_Z_6(6)
      , CZI8 => FIR_CASC_Z_6(7)
      , CZI9 => FIR_CASC_Z_6(8)
      , CZI10 => FIR_CASC_Z_6(9)
      , CZI11 => FIR_CASC_Z_6(10)
      , CZI12 => FIR_CASC_Z_6(11)
      , CZI13 => FIR_CASC_Z_6(12)
      , CZI14 => FIR_CASC_Z_6(13)
      , CZI15 => FIR_CASC_Z_6(14)
      , CZI16 => FIR_CASC_Z_6(15)
      , CZI17 => FIR_CASC_Z_6(16)
      , CZI18 => FIR_CASC_Z_6(17)
      , CZI19 => FIR_CASC_Z_6(18)
      , CZI20 => FIR_CASC_Z_6(19)
      , CZI21 => FIR_CASC_Z_6(20)
      , CZI22 => FIR_CASC_Z_6(21)
      , CZI23 => FIR_CASC_Z_6(22)
      , CZI24 => FIR_CASC_Z_6(23)
      , CZI25 => FIR_CASC_Z_6(24)
      , CZI26 => FIR_CASC_Z_6(25)
      , CZI27 => FIR_CASC_Z_6(26)
      , CZI28 => FIR_CASC_Z_6(27)
      , CZI29 => FIR_CASC_Z_6(28)
      , CZI30 => FIR_CASC_Z_6(29)
      , CZI31 => FIR_CASC_Z_6(30)
      , CZI32 => FIR_CASC_Z_6(31)
      , CZI33 => FIR_CASC_Z_6(32)
      , CZI34 => FIR_CASC_Z_6(33)
      , CZI35 => FIR_CASC_Z_6(34)
      , CZI36 => FIR_CASC_Z_6(35)
      , CZI37 => FIR_CASC_Z_6(36)
      , CZI38 => FIR_CASC_Z_6(37)
      , CZI39 => FIR_CASC_Z_6(38)
      , CZI40 => FIR_CASC_Z_6(39)
      , CZI41 => FIR_CASC_Z_6(40)
      , CZI42 => FIR_CASC_Z_6(41)
      , CZI43 => FIR_CASC_Z_6(42)
      , CZI44 => FIR_CASC_Z_6(43)
      , CZI45 => FIR_CASC_Z_6(44)
      , CZI46 => FIR_CASC_Z_6(45)
      , CZI47 => FIR_CASC_Z_6(46)
      , CZI48 => FIR_CASC_Z_6(47)
      , CZI49 => FIR_CASC_Z_6(48)
      , CZI50 => FIR_CASC_Z_6(49)
      , CZI51 => FIR_CASC_Z_6(50)
      , CZI52 => FIR_CASC_Z_6(51)
      , CZI53 => FIR_CASC_Z_6(52)
      , CZI54 => FIR_CASC_Z_6(53)
      , CZI55 => FIR_CASC_Z_6(54)
      , CZI56 => FIR_CASC_Z_6(55)
      , CZO1 => FIR_CASC_Z_7(0)
      , CZO2 => FIR_CASC_Z_7(1)
      , CZO3 => FIR_CASC_Z_7(2)
      , CZO4 => FIR_CASC_Z_7(3)
      , CZO5 => FIR_CASC_Z_7(4)
      , CZO6 => FIR_CASC_Z_7(5)
      , CZO7 => FIR_CASC_Z_7(6)
      , CZO8 => FIR_CASC_Z_7(7)
      , CZO9 => FIR_CASC_Z_7(8)
      , CZO10 => FIR_CASC_Z_7(9)
      , CZO11 => FIR_CASC_Z_7(10)
      , CZO12 => FIR_CASC_Z_7(11)
      , CZO13 => FIR_CASC_Z_7(12)
      , CZO14 => FIR_CASC_Z_7(13)
      , CZO15 => FIR_CASC_Z_7(14)
      , CZO16 => FIR_CASC_Z_7(15)
      , CZO17 => FIR_CASC_Z_7(16)
      , CZO18 => FIR_CASC_Z_7(17)
      , CZO19 => FIR_CASC_Z_7(18)
      , CZO20 => FIR_CASC_Z_7(19)
      , CZO21 => FIR_CASC_Z_7(20)
      , CZO22 => FIR_CASC_Z_7(21)
      , CZO23 => FIR_CASC_Z_7(22)
      , CZO24 => FIR_CASC_Z_7(23)
      , CZO25 => FIR_CASC_Z_7(24)
      , CZO26 => FIR_CASC_Z_7(25)
      , CZO27 => FIR_CASC_Z_7(26)
      , CZO28 => FIR_CASC_Z_7(27)
      , CZO29 => FIR_CASC_Z_7(28)
      , CZO30 => FIR_CASC_Z_7(29)
      , CZO31 => FIR_CASC_Z_7(30)
      , CZO32 => FIR_CASC_Z_7(31)
      , CZO33 => FIR_CASC_Z_7(32)
      , CZO34 => FIR_CASC_Z_7(33)
      , CZO35 => FIR_CASC_Z_7(34)
      , CZO36 => FIR_CASC_Z_7(35)
      , CZO37 => FIR_CASC_Z_7(36)
      , CZO38 => FIR_CASC_Z_7(37)
      , CZO39 => FIR_CASC_Z_7(38)
      , CZO40 => FIR_CASC_Z_7(39)
      , CZO41 => FIR_CASC_Z_7(40)
      , CZO42 => FIR_CASC_Z_7(41)
      , CZO43 => FIR_CASC_Z_7(42)
      , CZO44 => FIR_CASC_Z_7(43)
      , CZO45 => FIR_CASC_Z_7(44)
      , CZO46 => FIR_CASC_Z_7(45)
      , CZO47 => FIR_CASC_Z_7(46)
      , CZO48 => FIR_CASC_Z_7(47)
      , CZO49 => FIR_CASC_Z_7(48)
      , CZO50 => FIR_CASC_Z_7(49)
      , CZO51 => FIR_CASC_Z_7(50)
      , CZO52 => FIR_CASC_Z_7(51)
      , CZO53 => FIR_CASC_Z_7(52)
      , CZO54 => FIR_CASC_Z_7(53)
      , CZO55 => FIR_CASC_Z_7(54)
      , CZO56 => FIR_CASC_Z_7(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_8_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_1
      , A2   => global_0
      , A3   => global_0
      , A4   => global_0
      , A5   => global_0
      , A6   => global_1
      , A7   => global_0
      , A8   => global_1
      , A9   => global_0
      , A10  => global_1
      , A11  => global_1
      , A12  => global_1
      , A13  => global_0
      , A14  => global_0
      , A15  => global_0
      , A16  => global_0
      , A17  => global_0
      , A18  => global_0
      , A19  => global_0
      , A20  => global_0
      , A21  => global_0
      , A22  => global_0
      , A23  => global_0
      , A24  => global_0
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_7(0)
      , CBI2 => FIR_CASC_B_7(1)
      , CBI3 => FIR_CASC_B_7(2)
      , CBI4 => FIR_CASC_B_7(3)
      , CBI5 => FIR_CASC_B_7(4)
      , CBI6 => FIR_CASC_B_7(5)
      , CBI7 => FIR_CASC_B_7(6)
      , CBI8 => FIR_CASC_B_7(7)
      , CBI9 => FIR_CASC_B_7(8)
      , CBI10 => FIR_CASC_B_7(9)
      , CBI11 => FIR_CASC_B_7(10)
      , CBI12 => FIR_CASC_B_7(11)
      , CBI13 => FIR_CASC_B_7(12)
      , CBI14 => FIR_CASC_B_7(13)
      , CBI15 => FIR_CASC_B_7(14)
      , CBI16 => FIR_CASC_B_7(15)
      , CBI17 => FIR_CASC_B_7(16)
      , CBI18 => FIR_CASC_B_7(17)
      , CBO1 => FIR_CASC_B_8(0)
      , CBO2 => FIR_CASC_B_8(1)
      , CBO3 => FIR_CASC_B_8(2)
      , CBO4 => FIR_CASC_B_8(3)
      , CBO5 => FIR_CASC_B_8(4)
      , CBO6 => FIR_CASC_B_8(5)
      , CBO7 => FIR_CASC_B_8(6)
      , CBO8 => FIR_CASC_B_8(7)
      , CBO9 => FIR_CASC_B_8(8)
      , CBO10 => FIR_CASC_B_8(9)
      , CBO11 => FIR_CASC_B_8(10)
      , CBO12 => FIR_CASC_B_8(11)
      , CBO13 => FIR_CASC_B_8(12)
      , CBO14 => FIR_CASC_B_8(13)
      , CBO15 => FIR_CASC_B_8(14)
      , CBO16 => FIR_CASC_B_8(15)
      , CBO17 => FIR_CASC_B_8(16)
      , CBO18 => FIR_CASC_B_8(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_7(0)
      , CZI2 => FIR_CASC_Z_7(1)
      , CZI3 => FIR_CASC_Z_7(2)
      , CZI4 => FIR_CASC_Z_7(3)
      , CZI5 => FIR_CASC_Z_7(4)
      , CZI6 => FIR_CASC_Z_7(5)
      , CZI7 => FIR_CASC_Z_7(6)
      , CZI8 => FIR_CASC_Z_7(7)
      , CZI9 => FIR_CASC_Z_7(8)
      , CZI10 => FIR_CASC_Z_7(9)
      , CZI11 => FIR_CASC_Z_7(10)
      , CZI12 => FIR_CASC_Z_7(11)
      , CZI13 => FIR_CASC_Z_7(12)
      , CZI14 => FIR_CASC_Z_7(13)
      , CZI15 => FIR_CASC_Z_7(14)
      , CZI16 => FIR_CASC_Z_7(15)
      , CZI17 => FIR_CASC_Z_7(16)
      , CZI18 => FIR_CASC_Z_7(17)
      , CZI19 => FIR_CASC_Z_7(18)
      , CZI20 => FIR_CASC_Z_7(19)
      , CZI21 => FIR_CASC_Z_7(20)
      , CZI22 => FIR_CASC_Z_7(21)
      , CZI23 => FIR_CASC_Z_7(22)
      , CZI24 => FIR_CASC_Z_7(23)
      , CZI25 => FIR_CASC_Z_7(24)
      , CZI26 => FIR_CASC_Z_7(25)
      , CZI27 => FIR_CASC_Z_7(26)
      , CZI28 => FIR_CASC_Z_7(27)
      , CZI29 => FIR_CASC_Z_7(28)
      , CZI30 => FIR_CASC_Z_7(29)
      , CZI31 => FIR_CASC_Z_7(30)
      , CZI32 => FIR_CASC_Z_7(31)
      , CZI33 => FIR_CASC_Z_7(32)
      , CZI34 => FIR_CASC_Z_7(33)
      , CZI35 => FIR_CASC_Z_7(34)
      , CZI36 => FIR_CASC_Z_7(35)
      , CZI37 => FIR_CASC_Z_7(36)
      , CZI38 => FIR_CASC_Z_7(37)
      , CZI39 => FIR_CASC_Z_7(38)
      , CZI40 => FIR_CASC_Z_7(39)
      , CZI41 => FIR_CASC_Z_7(40)
      , CZI42 => FIR_CASC_Z_7(41)
      , CZI43 => FIR_CASC_Z_7(42)
      , CZI44 => FIR_CASC_Z_7(43)
      , CZI45 => FIR_CASC_Z_7(44)
      , CZI46 => FIR_CASC_Z_7(45)
      , CZI47 => FIR_CASC_Z_7(46)
      , CZI48 => FIR_CASC_Z_7(47)
      , CZI49 => FIR_CASC_Z_7(48)
      , CZI50 => FIR_CASC_Z_7(49)
      , CZI51 => FIR_CASC_Z_7(50)
      , CZI52 => FIR_CASC_Z_7(51)
      , CZI53 => FIR_CASC_Z_7(52)
      , CZI54 => FIR_CASC_Z_7(53)
      , CZI55 => FIR_CASC_Z_7(54)
      , CZI56 => FIR_CASC_Z_7(55)
      , CZO1 => FIR_CASC_Z_8(0)
      , CZO2 => FIR_CASC_Z_8(1)
      , CZO3 => FIR_CASC_Z_8(2)
      , CZO4 => FIR_CASC_Z_8(3)
      , CZO5 => FIR_CASC_Z_8(4)
      , CZO6 => FIR_CASC_Z_8(5)
      , CZO7 => FIR_CASC_Z_8(6)
      , CZO8 => FIR_CASC_Z_8(7)
      , CZO9 => FIR_CASC_Z_8(8)
      , CZO10 => FIR_CASC_Z_8(9)
      , CZO11 => FIR_CASC_Z_8(10)
      , CZO12 => FIR_CASC_Z_8(11)
      , CZO13 => FIR_CASC_Z_8(12)
      , CZO14 => FIR_CASC_Z_8(13)
      , CZO15 => FIR_CASC_Z_8(14)
      , CZO16 => FIR_CASC_Z_8(15)
      , CZO17 => FIR_CASC_Z_8(16)
      , CZO18 => FIR_CASC_Z_8(17)
      , CZO19 => FIR_CASC_Z_8(18)
      , CZO20 => FIR_CASC_Z_8(19)
      , CZO21 => FIR_CASC_Z_8(20)
      , CZO22 => FIR_CASC_Z_8(21)
      , CZO23 => FIR_CASC_Z_8(22)
      , CZO24 => FIR_CASC_Z_8(23)
      , CZO25 => FIR_CASC_Z_8(24)
      , CZO26 => FIR_CASC_Z_8(25)
      , CZO27 => FIR_CASC_Z_8(26)
      , CZO28 => FIR_CASC_Z_8(27)
      , CZO29 => FIR_CASC_Z_8(28)
      , CZO30 => FIR_CASC_Z_8(29)
      , CZO31 => FIR_CASC_Z_8(30)
      , CZO32 => FIR_CASC_Z_8(31)
      , CZO33 => FIR_CASC_Z_8(32)
      , CZO34 => FIR_CASC_Z_8(33)
      , CZO35 => FIR_CASC_Z_8(34)
      , CZO36 => FIR_CASC_Z_8(35)
      , CZO37 => FIR_CASC_Z_8(36)
      , CZO38 => FIR_CASC_Z_8(37)
      , CZO39 => FIR_CASC_Z_8(38)
      , CZO40 => FIR_CASC_Z_8(39)
      , CZO41 => FIR_CASC_Z_8(40)
      , CZO42 => FIR_CASC_Z_8(41)
      , CZO43 => FIR_CASC_Z_8(42)
      , CZO44 => FIR_CASC_Z_8(43)
      , CZO45 => FIR_CASC_Z_8(44)
      , CZO46 => FIR_CASC_Z_8(45)
      , CZO47 => FIR_CASC_Z_8(46)
      , CZO48 => FIR_CASC_Z_8(47)
      , CZO49 => FIR_CASC_Z_8(48)
      , CZO50 => FIR_CASC_Z_8(49)
      , CZO51 => FIR_CASC_Z_8(50)
      , CZO52 => FIR_CASC_Z_8(51)
      , CZO53 => FIR_CASC_Z_8(52)
      , CZO54 => FIR_CASC_Z_8(53)
      , CZO55 => FIR_CASC_Z_8(54)
      , CZO56 => FIR_CASC_Z_8(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_9_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_1
      , A2   => global_1
      , A3   => global_1
      , A4   => global_0
      , A5   => global_1
      , A6   => global_0
      , A7   => global_0
      , A8   => global_0
      , A9   => global_0
      , A10  => global_1
      , A11  => global_0
      , A12  => global_0
      , A13  => global_0
      , A14  => global_0
      , A15  => global_0
      , A16  => global_0
      , A17  => global_0
      , A18  => global_0
      , A19  => global_0
      , A20  => global_0
      , A21  => global_0
      , A22  => global_0
      , A23  => global_0
      , A24  => global_0
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_8(0)
      , CBI2 => FIR_CASC_B_8(1)
      , CBI3 => FIR_CASC_B_8(2)
      , CBI4 => FIR_CASC_B_8(3)
      , CBI5 => FIR_CASC_B_8(4)
      , CBI6 => FIR_CASC_B_8(5)
      , CBI7 => FIR_CASC_B_8(6)
      , CBI8 => FIR_CASC_B_8(7)
      , CBI9 => FIR_CASC_B_8(8)
      , CBI10 => FIR_CASC_B_8(9)
      , CBI11 => FIR_CASC_B_8(10)
      , CBI12 => FIR_CASC_B_8(11)
      , CBI13 => FIR_CASC_B_8(12)
      , CBI14 => FIR_CASC_B_8(13)
      , CBI15 => FIR_CASC_B_8(14)
      , CBI16 => FIR_CASC_B_8(15)
      , CBI17 => FIR_CASC_B_8(16)
      , CBI18 => FIR_CASC_B_8(17)
      , CBO1 => FIR_CASC_B_9(0)
      , CBO2 => FIR_CASC_B_9(1)
      , CBO3 => FIR_CASC_B_9(2)
      , CBO4 => FIR_CASC_B_9(3)
      , CBO5 => FIR_CASC_B_9(4)
      , CBO6 => FIR_CASC_B_9(5)
      , CBO7 => FIR_CASC_B_9(6)
      , CBO8 => FIR_CASC_B_9(7)
      , CBO9 => FIR_CASC_B_9(8)
      , CBO10 => FIR_CASC_B_9(9)
      , CBO11 => FIR_CASC_B_9(10)
      , CBO12 => FIR_CASC_B_9(11)
      , CBO13 => FIR_CASC_B_9(12)
      , CBO14 => FIR_CASC_B_9(13)
      , CBO15 => FIR_CASC_B_9(14)
      , CBO16 => FIR_CASC_B_9(15)
      , CBO17 => FIR_CASC_B_9(16)
      , CBO18 => FIR_CASC_B_9(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_8(0)
      , CZI2 => FIR_CASC_Z_8(1)
      , CZI3 => FIR_CASC_Z_8(2)
      , CZI4 => FIR_CASC_Z_8(3)
      , CZI5 => FIR_CASC_Z_8(4)
      , CZI6 => FIR_CASC_Z_8(5)
      , CZI7 => FIR_CASC_Z_8(6)
      , CZI8 => FIR_CASC_Z_8(7)
      , CZI9 => FIR_CASC_Z_8(8)
      , CZI10 => FIR_CASC_Z_8(9)
      , CZI11 => FIR_CASC_Z_8(10)
      , CZI12 => FIR_CASC_Z_8(11)
      , CZI13 => FIR_CASC_Z_8(12)
      , CZI14 => FIR_CASC_Z_8(13)
      , CZI15 => FIR_CASC_Z_8(14)
      , CZI16 => FIR_CASC_Z_8(15)
      , CZI17 => FIR_CASC_Z_8(16)
      , CZI18 => FIR_CASC_Z_8(17)
      , CZI19 => FIR_CASC_Z_8(18)
      , CZI20 => FIR_CASC_Z_8(19)
      , CZI21 => FIR_CASC_Z_8(20)
      , CZI22 => FIR_CASC_Z_8(21)
      , CZI23 => FIR_CASC_Z_8(22)
      , CZI24 => FIR_CASC_Z_8(23)
      , CZI25 => FIR_CASC_Z_8(24)
      , CZI26 => FIR_CASC_Z_8(25)
      , CZI27 => FIR_CASC_Z_8(26)
      , CZI28 => FIR_CASC_Z_8(27)
      , CZI29 => FIR_CASC_Z_8(28)
      , CZI30 => FIR_CASC_Z_8(29)
      , CZI31 => FIR_CASC_Z_8(30)
      , CZI32 => FIR_CASC_Z_8(31)
      , CZI33 => FIR_CASC_Z_8(32)
      , CZI34 => FIR_CASC_Z_8(33)
      , CZI35 => FIR_CASC_Z_8(34)
      , CZI36 => FIR_CASC_Z_8(35)
      , CZI37 => FIR_CASC_Z_8(36)
      , CZI38 => FIR_CASC_Z_8(37)
      , CZI39 => FIR_CASC_Z_8(38)
      , CZI40 => FIR_CASC_Z_8(39)
      , CZI41 => FIR_CASC_Z_8(40)
      , CZI42 => FIR_CASC_Z_8(41)
      , CZI43 => FIR_CASC_Z_8(42)
      , CZI44 => FIR_CASC_Z_8(43)
      , CZI45 => FIR_CASC_Z_8(44)
      , CZI46 => FIR_CASC_Z_8(45)
      , CZI47 => FIR_CASC_Z_8(46)
      , CZI48 => FIR_CASC_Z_8(47)
      , CZI49 => FIR_CASC_Z_8(48)
      , CZI50 => FIR_CASC_Z_8(49)
      , CZI51 => FIR_CASC_Z_8(50)
      , CZI52 => FIR_CASC_Z_8(51)
      , CZI53 => FIR_CASC_Z_8(52)
      , CZI54 => FIR_CASC_Z_8(53)
      , CZI55 => FIR_CASC_Z_8(54)
      , CZI56 => FIR_CASC_Z_8(55)
      , CZO1 => FIR_CASC_Z_9(0)
      , CZO2 => FIR_CASC_Z_9(1)
      , CZO3 => FIR_CASC_Z_9(2)
      , CZO4 => FIR_CASC_Z_9(3)
      , CZO5 => FIR_CASC_Z_9(4)
      , CZO6 => FIR_CASC_Z_9(5)
      , CZO7 => FIR_CASC_Z_9(6)
      , CZO8 => FIR_CASC_Z_9(7)
      , CZO9 => FIR_CASC_Z_9(8)
      , CZO10 => FIR_CASC_Z_9(9)
      , CZO11 => FIR_CASC_Z_9(10)
      , CZO12 => FIR_CASC_Z_9(11)
      , CZO13 => FIR_CASC_Z_9(12)
      , CZO14 => FIR_CASC_Z_9(13)
      , CZO15 => FIR_CASC_Z_9(14)
      , CZO16 => FIR_CASC_Z_9(15)
      , CZO17 => FIR_CASC_Z_9(16)
      , CZO18 => FIR_CASC_Z_9(17)
      , CZO19 => FIR_CASC_Z_9(18)
      , CZO20 => FIR_CASC_Z_9(19)
      , CZO21 => FIR_CASC_Z_9(20)
      , CZO22 => FIR_CASC_Z_9(21)
      , CZO23 => FIR_CASC_Z_9(22)
      , CZO24 => FIR_CASC_Z_9(23)
      , CZO25 => FIR_CASC_Z_9(24)
      , CZO26 => FIR_CASC_Z_9(25)
      , CZO27 => FIR_CASC_Z_9(26)
      , CZO28 => FIR_CASC_Z_9(27)
      , CZO29 => FIR_CASC_Z_9(28)
      , CZO30 => FIR_CASC_Z_9(29)
      , CZO31 => FIR_CASC_Z_9(30)
      , CZO32 => FIR_CASC_Z_9(31)
      , CZO33 => FIR_CASC_Z_9(32)
      , CZO34 => FIR_CASC_Z_9(33)
      , CZO35 => FIR_CASC_Z_9(34)
      , CZO36 => FIR_CASC_Z_9(35)
      , CZO37 => FIR_CASC_Z_9(36)
      , CZO38 => FIR_CASC_Z_9(37)
      , CZO39 => FIR_CASC_Z_9(38)
      , CZO40 => FIR_CASC_Z_9(39)
      , CZO41 => FIR_CASC_Z_9(40)
      , CZO42 => FIR_CASC_Z_9(41)
      , CZO43 => FIR_CASC_Z_9(42)
      , CZO44 => FIR_CASC_Z_9(43)
      , CZO45 => FIR_CASC_Z_9(44)
      , CZO46 => FIR_CASC_Z_9(45)
      , CZO47 => FIR_CASC_Z_9(46)
      , CZO48 => FIR_CASC_Z_9(47)
      , CZO49 => FIR_CASC_Z_9(48)
      , CZO50 => FIR_CASC_Z_9(49)
      , CZO51 => FIR_CASC_Z_9(50)
      , CZO52 => FIR_CASC_Z_9(51)
      , CZO53 => FIR_CASC_Z_9(52)
      , CZO54 => FIR_CASC_Z_9(53)
      , CZO55 => FIR_CASC_Z_9(54)
      , CZO56 => FIR_CASC_Z_9(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_10_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_0
      , A2   => global_0
      , A3   => global_1
      , A4   => global_1
      , A5   => global_1
      , A6   => global_1
      , A7   => global_1
      , A8   => global_0
      , A9   => global_1
      , A10  => global_0
      , A11  => global_1
      , A12  => global_1
      , A13  => global_1
      , A14  => global_1
      , A15  => global_1
      , A16  => global_1
      , A17  => global_1
      , A18  => global_1
      , A19  => global_1
      , A20  => global_1
      , A21  => global_1
      , A22  => global_1
      , A23  => global_1
      , A24  => global_1
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_9(0)
      , CBI2 => FIR_CASC_B_9(1)
      , CBI3 => FIR_CASC_B_9(2)
      , CBI4 => FIR_CASC_B_9(3)
      , CBI5 => FIR_CASC_B_9(4)
      , CBI6 => FIR_CASC_B_9(5)
      , CBI7 => FIR_CASC_B_9(6)
      , CBI8 => FIR_CASC_B_9(7)
      , CBI9 => FIR_CASC_B_9(8)
      , CBI10 => FIR_CASC_B_9(9)
      , CBI11 => FIR_CASC_B_9(10)
      , CBI12 => FIR_CASC_B_9(11)
      , CBI13 => FIR_CASC_B_9(12)
      , CBI14 => FIR_CASC_B_9(13)
      , CBI15 => FIR_CASC_B_9(14)
      , CBI16 => FIR_CASC_B_9(15)
      , CBI17 => FIR_CASC_B_9(16)
      , CBI18 => FIR_CASC_B_9(17)
      , CBO1 => FIR_CASC_B_10(0)
      , CBO2 => FIR_CASC_B_10(1)
      , CBO3 => FIR_CASC_B_10(2)
      , CBO4 => FIR_CASC_B_10(3)
      , CBO5 => FIR_CASC_B_10(4)
      , CBO6 => FIR_CASC_B_10(5)
      , CBO7 => FIR_CASC_B_10(6)
      , CBO8 => FIR_CASC_B_10(7)
      , CBO9 => FIR_CASC_B_10(8)
      , CBO10 => FIR_CASC_B_10(9)
      , CBO11 => FIR_CASC_B_10(10)
      , CBO12 => FIR_CASC_B_10(11)
      , CBO13 => FIR_CASC_B_10(12)
      , CBO14 => FIR_CASC_B_10(13)
      , CBO15 => FIR_CASC_B_10(14)
      , CBO16 => FIR_CASC_B_10(15)
      , CBO17 => FIR_CASC_B_10(16)
      , CBO18 => FIR_CASC_B_10(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_9(0)
      , CZI2 => FIR_CASC_Z_9(1)
      , CZI3 => FIR_CASC_Z_9(2)
      , CZI4 => FIR_CASC_Z_9(3)
      , CZI5 => FIR_CASC_Z_9(4)
      , CZI6 => FIR_CASC_Z_9(5)
      , CZI7 => FIR_CASC_Z_9(6)
      , CZI8 => FIR_CASC_Z_9(7)
      , CZI9 => FIR_CASC_Z_9(8)
      , CZI10 => FIR_CASC_Z_9(9)
      , CZI11 => FIR_CASC_Z_9(10)
      , CZI12 => FIR_CASC_Z_9(11)
      , CZI13 => FIR_CASC_Z_9(12)
      , CZI14 => FIR_CASC_Z_9(13)
      , CZI15 => FIR_CASC_Z_9(14)
      , CZI16 => FIR_CASC_Z_9(15)
      , CZI17 => FIR_CASC_Z_9(16)
      , CZI18 => FIR_CASC_Z_9(17)
      , CZI19 => FIR_CASC_Z_9(18)
      , CZI20 => FIR_CASC_Z_9(19)
      , CZI21 => FIR_CASC_Z_9(20)
      , CZI22 => FIR_CASC_Z_9(21)
      , CZI23 => FIR_CASC_Z_9(22)
      , CZI24 => FIR_CASC_Z_9(23)
      , CZI25 => FIR_CASC_Z_9(24)
      , CZI26 => FIR_CASC_Z_9(25)
      , CZI27 => FIR_CASC_Z_9(26)
      , CZI28 => FIR_CASC_Z_9(27)
      , CZI29 => FIR_CASC_Z_9(28)
      , CZI30 => FIR_CASC_Z_9(29)
      , CZI31 => FIR_CASC_Z_9(30)
      , CZI32 => FIR_CASC_Z_9(31)
      , CZI33 => FIR_CASC_Z_9(32)
      , CZI34 => FIR_CASC_Z_9(33)
      , CZI35 => FIR_CASC_Z_9(34)
      , CZI36 => FIR_CASC_Z_9(35)
      , CZI37 => FIR_CASC_Z_9(36)
      , CZI38 => FIR_CASC_Z_9(37)
      , CZI39 => FIR_CASC_Z_9(38)
      , CZI40 => FIR_CASC_Z_9(39)
      , CZI41 => FIR_CASC_Z_9(40)
      , CZI42 => FIR_CASC_Z_9(41)
      , CZI43 => FIR_CASC_Z_9(42)
      , CZI44 => FIR_CASC_Z_9(43)
      , CZI45 => FIR_CASC_Z_9(44)
      , CZI46 => FIR_CASC_Z_9(45)
      , CZI47 => FIR_CASC_Z_9(46)
      , CZI48 => FIR_CASC_Z_9(47)
      , CZI49 => FIR_CASC_Z_9(48)
      , CZI50 => FIR_CASC_Z_9(49)
      , CZI51 => FIR_CASC_Z_9(50)
      , CZI52 => FIR_CASC_Z_9(51)
      , CZI53 => FIR_CASC_Z_9(52)
      , CZI54 => FIR_CASC_Z_9(53)
      , CZI55 => FIR_CASC_Z_9(54)
      , CZI56 => FIR_CASC_Z_9(55)
      , CZO1 => FIR_CASC_Z_10(0)
      , CZO2 => FIR_CASC_Z_10(1)
      , CZO3 => FIR_CASC_Z_10(2)
      , CZO4 => FIR_CASC_Z_10(3)
      , CZO5 => FIR_CASC_Z_10(4)
      , CZO6 => FIR_CASC_Z_10(5)
      , CZO7 => FIR_CASC_Z_10(6)
      , CZO8 => FIR_CASC_Z_10(7)
      , CZO9 => FIR_CASC_Z_10(8)
      , CZO10 => FIR_CASC_Z_10(9)
      , CZO11 => FIR_CASC_Z_10(10)
      , CZO12 => FIR_CASC_Z_10(11)
      , CZO13 => FIR_CASC_Z_10(12)
      , CZO14 => FIR_CASC_Z_10(13)
      , CZO15 => FIR_CASC_Z_10(14)
      , CZO16 => FIR_CASC_Z_10(15)
      , CZO17 => FIR_CASC_Z_10(16)
      , CZO18 => FIR_CASC_Z_10(17)
      , CZO19 => FIR_CASC_Z_10(18)
      , CZO20 => FIR_CASC_Z_10(19)
      , CZO21 => FIR_CASC_Z_10(20)
      , CZO22 => FIR_CASC_Z_10(21)
      , CZO23 => FIR_CASC_Z_10(22)
      , CZO24 => FIR_CASC_Z_10(23)
      , CZO25 => FIR_CASC_Z_10(24)
      , CZO26 => FIR_CASC_Z_10(25)
      , CZO27 => FIR_CASC_Z_10(26)
      , CZO28 => FIR_CASC_Z_10(27)
      , CZO29 => FIR_CASC_Z_10(28)
      , CZO30 => FIR_CASC_Z_10(29)
      , CZO31 => FIR_CASC_Z_10(30)
      , CZO32 => FIR_CASC_Z_10(31)
      , CZO33 => FIR_CASC_Z_10(32)
      , CZO34 => FIR_CASC_Z_10(33)
      , CZO35 => FIR_CASC_Z_10(34)
      , CZO36 => FIR_CASC_Z_10(35)
      , CZO37 => FIR_CASC_Z_10(36)
      , CZO38 => FIR_CASC_Z_10(37)
      , CZO39 => FIR_CASC_Z_10(38)
      , CZO40 => FIR_CASC_Z_10(39)
      , CZO41 => FIR_CASC_Z_10(40)
      , CZO42 => FIR_CASC_Z_10(41)
      , CZO43 => FIR_CASC_Z_10(42)
      , CZO44 => FIR_CASC_Z_10(43)
      , CZO45 => FIR_CASC_Z_10(44)
      , CZO46 => FIR_CASC_Z_10(45)
      , CZO47 => FIR_CASC_Z_10(46)
      , CZO48 => FIR_CASC_Z_10(47)
      , CZO49 => FIR_CASC_Z_10(48)
      , CZO50 => FIR_CASC_Z_10(49)
      , CZO51 => FIR_CASC_Z_10(50)
      , CZO52 => FIR_CASC_Z_10(51)
      , CZO53 => FIR_CASC_Z_10(52)
      , CZO54 => FIR_CASC_Z_10(53)
      , CZO55 => FIR_CASC_Z_10(54)
      , CZO56 => FIR_CASC_Z_10(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_11_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_0
      , A2   => global_0
      , A3   => global_1
      , A4   => global_1
      , A5   => global_0
      , A6   => global_1
      , A7   => global_0
      , A8   => global_1
      , A9   => global_1
      , A10  => global_0
      , A11  => global_1
      , A12  => global_1
      , A13  => global_1
      , A14  => global_1
      , A15  => global_1
      , A16  => global_1
      , A17  => global_1
      , A18  => global_1
      , A19  => global_1
      , A20  => global_1
      , A21  => global_1
      , A22  => global_1
      , A23  => global_1
      , A24  => global_1
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_10(0)
      , CBI2 => FIR_CASC_B_10(1)
      , CBI3 => FIR_CASC_B_10(2)
      , CBI4 => FIR_CASC_B_10(3)
      , CBI5 => FIR_CASC_B_10(4)
      , CBI6 => FIR_CASC_B_10(5)
      , CBI7 => FIR_CASC_B_10(6)
      , CBI8 => FIR_CASC_B_10(7)
      , CBI9 => FIR_CASC_B_10(8)
      , CBI10 => FIR_CASC_B_10(9)
      , CBI11 => FIR_CASC_B_10(10)
      , CBI12 => FIR_CASC_B_10(11)
      , CBI13 => FIR_CASC_B_10(12)
      , CBI14 => FIR_CASC_B_10(13)
      , CBI15 => FIR_CASC_B_10(14)
      , CBI16 => FIR_CASC_B_10(15)
      , CBI17 => FIR_CASC_B_10(16)
      , CBI18 => FIR_CASC_B_10(17)
      , CBO1 => FIR_CASC_B_11(0)
      , CBO2 => FIR_CASC_B_11(1)
      , CBO3 => FIR_CASC_B_11(2)
      , CBO4 => FIR_CASC_B_11(3)
      , CBO5 => FIR_CASC_B_11(4)
      , CBO6 => FIR_CASC_B_11(5)
      , CBO7 => FIR_CASC_B_11(6)
      , CBO8 => FIR_CASC_B_11(7)
      , CBO9 => FIR_CASC_B_11(8)
      , CBO10 => FIR_CASC_B_11(9)
      , CBO11 => FIR_CASC_B_11(10)
      , CBO12 => FIR_CASC_B_11(11)
      , CBO13 => FIR_CASC_B_11(12)
      , CBO14 => FIR_CASC_B_11(13)
      , CBO15 => FIR_CASC_B_11(14)
      , CBO16 => FIR_CASC_B_11(15)
      , CBO17 => FIR_CASC_B_11(16)
      , CBO18 => FIR_CASC_B_11(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_10(0)
      , CZI2 => FIR_CASC_Z_10(1)
      , CZI3 => FIR_CASC_Z_10(2)
      , CZI4 => FIR_CASC_Z_10(3)
      , CZI5 => FIR_CASC_Z_10(4)
      , CZI6 => FIR_CASC_Z_10(5)
      , CZI7 => FIR_CASC_Z_10(6)
      , CZI8 => FIR_CASC_Z_10(7)
      , CZI9 => FIR_CASC_Z_10(8)
      , CZI10 => FIR_CASC_Z_10(9)
      , CZI11 => FIR_CASC_Z_10(10)
      , CZI12 => FIR_CASC_Z_10(11)
      , CZI13 => FIR_CASC_Z_10(12)
      , CZI14 => FIR_CASC_Z_10(13)
      , CZI15 => FIR_CASC_Z_10(14)
      , CZI16 => FIR_CASC_Z_10(15)
      , CZI17 => FIR_CASC_Z_10(16)
      , CZI18 => FIR_CASC_Z_10(17)
      , CZI19 => FIR_CASC_Z_10(18)
      , CZI20 => FIR_CASC_Z_10(19)
      , CZI21 => FIR_CASC_Z_10(20)
      , CZI22 => FIR_CASC_Z_10(21)
      , CZI23 => FIR_CASC_Z_10(22)
      , CZI24 => FIR_CASC_Z_10(23)
      , CZI25 => FIR_CASC_Z_10(24)
      , CZI26 => FIR_CASC_Z_10(25)
      , CZI27 => FIR_CASC_Z_10(26)
      , CZI28 => FIR_CASC_Z_10(27)
      , CZI29 => FIR_CASC_Z_10(28)
      , CZI30 => FIR_CASC_Z_10(29)
      , CZI31 => FIR_CASC_Z_10(30)
      , CZI32 => FIR_CASC_Z_10(31)
      , CZI33 => FIR_CASC_Z_10(32)
      , CZI34 => FIR_CASC_Z_10(33)
      , CZI35 => FIR_CASC_Z_10(34)
      , CZI36 => FIR_CASC_Z_10(35)
      , CZI37 => FIR_CASC_Z_10(36)
      , CZI38 => FIR_CASC_Z_10(37)
      , CZI39 => FIR_CASC_Z_10(38)
      , CZI40 => FIR_CASC_Z_10(39)
      , CZI41 => FIR_CASC_Z_10(40)
      , CZI42 => FIR_CASC_Z_10(41)
      , CZI43 => FIR_CASC_Z_10(42)
      , CZI44 => FIR_CASC_Z_10(43)
      , CZI45 => FIR_CASC_Z_10(44)
      , CZI46 => FIR_CASC_Z_10(45)
      , CZI47 => FIR_CASC_Z_10(46)
      , CZI48 => FIR_CASC_Z_10(47)
      , CZI49 => FIR_CASC_Z_10(48)
      , CZI50 => FIR_CASC_Z_10(49)
      , CZI51 => FIR_CASC_Z_10(50)
      , CZI52 => FIR_CASC_Z_10(51)
      , CZI53 => FIR_CASC_Z_10(52)
      , CZI54 => FIR_CASC_Z_10(53)
      , CZI55 => FIR_CASC_Z_10(54)
      , CZI56 => FIR_CASC_Z_10(55)
      , CZO1 => FIR_CASC_Z_11(0)
      , CZO2 => FIR_CASC_Z_11(1)
      , CZO3 => FIR_CASC_Z_11(2)
      , CZO4 => FIR_CASC_Z_11(3)
      , CZO5 => FIR_CASC_Z_11(4)
      , CZO6 => FIR_CASC_Z_11(5)
      , CZO7 => FIR_CASC_Z_11(6)
      , CZO8 => FIR_CASC_Z_11(7)
      , CZO9 => FIR_CASC_Z_11(8)
      , CZO10 => FIR_CASC_Z_11(9)
      , CZO11 => FIR_CASC_Z_11(10)
      , CZO12 => FIR_CASC_Z_11(11)
      , CZO13 => FIR_CASC_Z_11(12)
      , CZO14 => FIR_CASC_Z_11(13)
      , CZO15 => FIR_CASC_Z_11(14)
      , CZO16 => FIR_CASC_Z_11(15)
      , CZO17 => FIR_CASC_Z_11(16)
      , CZO18 => FIR_CASC_Z_11(17)
      , CZO19 => FIR_CASC_Z_11(18)
      , CZO20 => FIR_CASC_Z_11(19)
      , CZO21 => FIR_CASC_Z_11(20)
      , CZO22 => FIR_CASC_Z_11(21)
      , CZO23 => FIR_CASC_Z_11(22)
      , CZO24 => FIR_CASC_Z_11(23)
      , CZO25 => FIR_CASC_Z_11(24)
      , CZO26 => FIR_CASC_Z_11(25)
      , CZO27 => FIR_CASC_Z_11(26)
      , CZO28 => FIR_CASC_Z_11(27)
      , CZO29 => FIR_CASC_Z_11(28)
      , CZO30 => FIR_CASC_Z_11(29)
      , CZO31 => FIR_CASC_Z_11(30)
      , CZO32 => FIR_CASC_Z_11(31)
      , CZO33 => FIR_CASC_Z_11(32)
      , CZO34 => FIR_CASC_Z_11(33)
      , CZO35 => FIR_CASC_Z_11(34)
      , CZO36 => FIR_CASC_Z_11(35)
      , CZO37 => FIR_CASC_Z_11(36)
      , CZO38 => FIR_CASC_Z_11(37)
      , CZO39 => FIR_CASC_Z_11(38)
      , CZO40 => FIR_CASC_Z_11(39)
      , CZO41 => FIR_CASC_Z_11(40)
      , CZO42 => FIR_CASC_Z_11(41)
      , CZO43 => FIR_CASC_Z_11(42)
      , CZO44 => FIR_CASC_Z_11(43)
      , CZO45 => FIR_CASC_Z_11(44)
      , CZO46 => FIR_CASC_Z_11(45)
      , CZO47 => FIR_CASC_Z_11(46)
      , CZO48 => FIR_CASC_Z_11(47)
      , CZO49 => FIR_CASC_Z_11(48)
      , CZO50 => FIR_CASC_Z_11(49)
      , CZO51 => FIR_CASC_Z_11(50)
      , CZO52 => FIR_CASC_Z_11(51)
      , CZO53 => FIR_CASC_Z_11(52)
      , CZO54 => FIR_CASC_Z_11(53)
      , CZO55 => FIR_CASC_Z_11(54)
      , CZO56 => FIR_CASC_Z_11(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_FIR_GEN_CELL_1_TO_N_M2_12_CELL_X_DSP_CELL_DSP_INST : NX_DSP
    generic map (
        raw_config0 => b"00110111000000111001"
      , raw_config1 => b"0001010110000010010001"
      , raw_config2 => b"1111111111111"
      , raw_config3 => b"0000000"
    )
    port map (
        A1   => global_0
      , A2   => global_1
      , A3   => global_1
      , A4   => global_1
      , A5   => global_0
      , A6   => global_1
      , A7   => global_1
      , A8   => global_0
      , A9   => global_1
      , A10  => global_1
      , A11  => global_1
      , A12  => global_1
      , A13  => global_1
      , A14  => global_1
      , A15  => global_1
      , A16  => global_1
      , A17  => global_1
      , A18  => global_1
      , A19  => global_1
      , A20  => global_1
      , A21  => global_1
      , A22  => global_1
      , A23  => global_1
      , A24  => global_1
      , B1   => global_0
      , B2   => global_0
      , B3   => global_0
      , B4   => global_0
      , B5   => global_0
      , B6   => global_0
      , B7   => global_0
      , B8   => global_0
      , B9   => global_0
      , B10  => global_0
      , B11  => global_0
      , B12  => global_0
      , B13  => global_0
      , B14  => global_0
      , B15  => global_0
      , B16  => global_0
      , B17  => global_0
      , B18  => global_0
      , C1   => global_0
      , C2   => global_0
      , C3   => global_0
      , C4   => global_0
      , C5   => global_0
      , C6   => global_0
      , C7   => global_0
      , C8   => global_0
      , C9   => global_0
      , C10  => global_0
      , C11  => global_0
      , C12  => global_0
      , C13  => global_0
      , C14  => global_0
      , C15  => global_0
      , C16  => global_0
      , C17  => global_0
      , C18  => global_0
      , C19  => global_0
      , C20  => global_0
      , C21  => global_0
      , C22  => global_0
      , C23  => global_0
      , C24  => global_0
      , C25  => global_0
      , C26  => global_0
      , C27  => global_0
      , C28  => global_0
      , C29  => global_0
      , C30  => global_0
      , C31  => global_0
      , C32  => global_0
      , C33  => global_0
      , C34  => global_0
      , C35  => global_0
      , C36  => global_0
      , CAI1 => global_0
      , CAI2 => global_0
      , CAI3 => global_0
      , CAI4 => global_0
      , CAI5 => global_0
      , CAI6 => global_0
      , CAI7 => global_0
      , CAI8 => global_0
      , CAI9 => global_0
      , CAI10 => global_0
      , CAI11 => global_0
      , CAI12 => global_0
      , CAI13 => global_0
      , CAI14 => global_0
      , CAI15 => global_0
      , CAI16 => global_0
      , CAI17 => global_0
      , CAI18 => global_0
      , CAO1 => OPEN
      , CAO2 => OPEN
      , CAO3 => OPEN
      , CAO4 => OPEN
      , CAO5 => OPEN
      , CAO6 => OPEN
      , CAO7 => OPEN
      , CAO8 => OPEN
      , CAO9 => OPEN
      , CAO10 => OPEN
      , CAO11 => OPEN
      , CAO12 => OPEN
      , CAO13 => OPEN
      , CAO14 => OPEN
      , CAO15 => OPEN
      , CAO16 => OPEN
      , CAO17 => OPEN
      , CAO18 => OPEN
      , CBI1 => FIR_CASC_B_11(0)
      , CBI2 => FIR_CASC_B_11(1)
      , CBI3 => FIR_CASC_B_11(2)
      , CBI4 => FIR_CASC_B_11(3)
      , CBI5 => FIR_CASC_B_11(4)
      , CBI6 => FIR_CASC_B_11(5)
      , CBI7 => FIR_CASC_B_11(6)
      , CBI8 => FIR_CASC_B_11(7)
      , CBI9 => FIR_CASC_B_11(8)
      , CBI10 => FIR_CASC_B_11(9)
      , CBI11 => FIR_CASC_B_11(10)
      , CBI12 => FIR_CASC_B_11(11)
      , CBI13 => FIR_CASC_B_11(12)
      , CBI14 => FIR_CASC_B_11(13)
      , CBI15 => FIR_CASC_B_11(14)
      , CBI16 => FIR_CASC_B_11(15)
      , CBI17 => FIR_CASC_B_11(16)
      , CBI18 => FIR_CASC_B_11(17)
      , CBO1 => FIR_CASC_B_12(0)
      , CBO2 => FIR_CASC_B_12(1)
      , CBO3 => FIR_CASC_B_12(2)
      , CBO4 => FIR_CASC_B_12(3)
      , CBO5 => FIR_CASC_B_12(4)
      , CBO6 => FIR_CASC_B_12(5)
      , CBO7 => FIR_CASC_B_12(6)
      , CBO8 => FIR_CASC_B_12(7)
      , CBO9 => FIR_CASC_B_12(8)
      , CBO10 => FIR_CASC_B_12(9)
      , CBO11 => FIR_CASC_B_12(10)
      , CBO12 => FIR_CASC_B_12(11)
      , CBO13 => FIR_CASC_B_12(12)
      , CBO14 => FIR_CASC_B_12(13)
      , CBO15 => FIR_CASC_B_12(14)
      , CBO16 => FIR_CASC_B_12(15)
      , CBO17 => FIR_CASC_B_12(16)
      , CBO18 => FIR_CASC_B_12(17)
      , CCI  => OPEN
      , CCO  => OPEN
      , CI   => global_0
      , CK   => CLK
      , CO   => OPEN
      , CO37 => OPEN
      , CO49 => OPEN
      , CZI1 => FIR_CASC_Z_11(0)
      , CZI2 => FIR_CASC_Z_11(1)
      , CZI3 => FIR_CASC_Z_11(2)
      , CZI4 => FIR_CASC_Z_11(3)
      , CZI5 => FIR_CASC_Z_11(4)
      , CZI6 => FIR_CASC_Z_11(5)
      , CZI7 => FIR_CASC_Z_11(6)
      , CZI8 => FIR_CASC_Z_11(7)
      , CZI9 => FIR_CASC_Z_11(8)
      , CZI10 => FIR_CASC_Z_11(9)
      , CZI11 => FIR_CASC_Z_11(10)
      , CZI12 => FIR_CASC_Z_11(11)
      , CZI13 => FIR_CASC_Z_11(12)
      , CZI14 => FIR_CASC_Z_11(13)
      , CZI15 => FIR_CASC_Z_11(14)
      , CZI16 => FIR_CASC_Z_11(15)
      , CZI17 => FIR_CASC_Z_11(16)
      , CZI18 => FIR_CASC_Z_11(17)
      , CZI19 => FIR_CASC_Z_11(18)
      , CZI20 => FIR_CASC_Z_11(19)
      , CZI21 => FIR_CASC_Z_11(20)
      , CZI22 => FIR_CASC_Z_11(21)
      , CZI23 => FIR_CASC_Z_11(22)
      , CZI24 => FIR_CASC_Z_11(23)
      , CZI25 => FIR_CASC_Z_11(24)
      , CZI26 => FIR_CASC_Z_11(25)
      , CZI27 => FIR_CASC_Z_11(26)
      , CZI28 => FIR_CASC_Z_11(27)
      , CZI29 => FIR_CASC_Z_11(28)
      , CZI30 => FIR_CASC_Z_11(29)
      , CZI31 => FIR_CASC_Z_11(30)
      , CZI32 => FIR_CASC_Z_11(31)
      , CZI33 => FIR_CASC_Z_11(32)
      , CZI34 => FIR_CASC_Z_11(33)
      , CZI35 => FIR_CASC_Z_11(34)
      , CZI36 => FIR_CASC_Z_11(35)
      , CZI37 => FIR_CASC_Z_11(36)
      , CZI38 => FIR_CASC_Z_11(37)
      , CZI39 => FIR_CASC_Z_11(38)
      , CZI40 => FIR_CASC_Z_11(39)
      , CZI41 => FIR_CASC_Z_11(40)
      , CZI42 => FIR_CASC_Z_11(41)
      , CZI43 => FIR_CASC_Z_11(42)
      , CZI44 => FIR_CASC_Z_11(43)
      , CZI45 => FIR_CASC_Z_11(44)
      , CZI46 => FIR_CASC_Z_11(45)
      , CZI47 => FIR_CASC_Z_11(46)
      , CZI48 => FIR_CASC_Z_11(47)
      , CZI49 => FIR_CASC_Z_11(48)
      , CZI50 => FIR_CASC_Z_11(49)
      , CZI51 => FIR_CASC_Z_11(50)
      , CZI52 => FIR_CASC_Z_11(51)
      , CZI53 => FIR_CASC_Z_11(52)
      , CZI54 => FIR_CASC_Z_11(53)
      , CZI55 => FIR_CASC_Z_11(54)
      , CZI56 => FIR_CASC_Z_11(55)
      , CZO1 => FIR_CASC_Z_12(0)
      , CZO2 => FIR_CASC_Z_12(1)
      , CZO3 => FIR_CASC_Z_12(2)
      , CZO4 => FIR_CASC_Z_12(3)
      , CZO5 => FIR_CASC_Z_12(4)
      , CZO6 => FIR_CASC_Z_12(5)
      , CZO7 => FIR_CASC_Z_12(6)
      , CZO8 => FIR_CASC_Z_12(7)
      , CZO9 => FIR_CASC_Z_12(8)
      , CZO10 => FIR_CASC_Z_12(9)
      , CZO11 => FIR_CASC_Z_12(10)
      , CZO12 => FIR_CASC_Z_12(11)
      , CZO13 => FIR_CASC_Z_12(12)
      , CZO14 => FIR_CASC_Z_12(13)
      , CZO15 => FIR_CASC_Z_12(14)
      , CZO16 => FIR_CASC_Z_12(15)
      , CZO17 => FIR_CASC_Z_12(16)
      , CZO18 => FIR_CASC_Z_12(17)
      , CZO19 => FIR_CASC_Z_12(18)
      , CZO20 => FIR_CASC_Z_12(19)
      , CZO21 => FIR_CASC_Z_12(20)
      , CZO22 => FIR_CASC_Z_12(21)
      , CZO23 => FIR_CASC_Z_12(22)
      , CZO24 => FIR_CASC_Z_12(23)
      , CZO25 => FIR_CASC_Z_12(24)
      , CZO26 => FIR_CASC_Z_12(25)
      , CZO27 => FIR_CASC_Z_12(26)
      , CZO28 => FIR_CASC_Z_12(27)
      , CZO29 => FIR_CASC_Z_12(28)
      , CZO30 => FIR_CASC_Z_12(29)
      , CZO31 => FIR_CASC_Z_12(30)
      , CZO32 => FIR_CASC_Z_12(31)
      , CZO33 => FIR_CASC_Z_12(32)
      , CZO34 => FIR_CASC_Z_12(33)
      , CZO35 => FIR_CASC_Z_12(34)
      , CZO36 => FIR_CASC_Z_12(35)
      , CZO37 => FIR_CASC_Z_12(36)
      , CZO38 => FIR_CASC_Z_12(37)
      , CZO39 => FIR_CASC_Z_12(38)
      , CZO40 => FIR_CASC_Z_12(39)
      , CZO41 => FIR_CASC_Z_12(40)
      , CZO42 => FIR_CASC_Z_12(41)
      , CZO43 => FIR_CASC_Z_12(42)
      , CZO44 => FIR_CASC_Z_12(43)
      , CZO45 => FIR_CASC_Z_12(44)
      , CZO46 => FIR_CASC_Z_12(45)
      , CZO47 => FIR_CASC_Z_12(46)
      , CZO48 => FIR_CASC_Z_12(47)
      , CZO49 => FIR_CASC_Z_12(48)
      , CZO50 => FIR_CASC_Z_12(49)
      , CZO51 => FIR_CASC_Z_12(50)
      , CZO52 => FIR_CASC_Z_12(51)
      , CZO53 => FIR_CASC_Z_12(52)
      , CZO54 => FIR_CASC_Z_12(53)
      , CZO55 => FIR_CASC_Z_12(54)
      , CZO56 => FIR_CASC_Z_12(55)
      , D1   => global_0
      , D2   => global_0
      , D3   => global_0
      , D4   => global_0
      , D5   => global_0
      , D6   => global_0
      , D7   => global_0
      , D8   => global_0
      , D9   => global_0
      , D10  => global_0
      , D11  => global_0
      , D12  => global_0
      , D13  => global_0
      , D14  => global_0
      , D15  => global_0
      , D16  => global_0
      , D17  => global_0
      , D18  => global_0
      , OVF  => OPEN
      , R    => SRST
      , RZ   => SRST
      , WE   => ENA
      , Z1   => OPEN
      , Z2   => OPEN
      , Z3   => OPEN
      , Z4   => OPEN
      , Z5   => OPEN
      , Z6   => OPEN
      , Z7   => OPEN
      , Z8   => OPEN
      , Z9   => OPEN
      , Z10  => OPEN
      , Z11  => OPEN
      , Z12  => OPEN
      , Z13  => OPEN
      , Z14  => OPEN
      , Z15  => OPEN
      , Z16  => OPEN
      , Z17  => OPEN
      , Z18  => OPEN
      , Z19  => OPEN
      , Z20  => OPEN
      , Z21  => OPEN
      , Z22  => OPEN
      , Z23  => OPEN
      , Z24  => OPEN
      , Z25  => OPEN
      , Z26  => OPEN
      , Z27  => OPEN
      , Z28  => OPEN
      , Z29  => OPEN
      , Z30  => OPEN
      , Z31  => OPEN
      , Z32  => OPEN
      , Z33  => OPEN
      , Z34  => OPEN
      , Z35  => OPEN
      , Z36  => OPEN
      , Z37  => OPEN
      , Z38  => OPEN
      , Z39  => OPEN
      , Z40  => OPEN
      , Z41  => OPEN
      , Z42  => OPEN
      , Z43  => OPEN
      , Z44  => OPEN
      , Z45  => OPEN
      , Z46  => OPEN
      , Z47  => OPEN
      , Z48  => OPEN
      , Z49  => OPEN
      , Z50  => OPEN
      , Z51  => OPEN
      , Z52  => OPEN
      , Z53  => OPEN
      , Z54  => OPEN
      , Z55  => OPEN
      , Z56  => OPEN
    );

  i_DIN_R2_reg_0 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(0)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(0)
      , R    => OPEN
    );

  i_DIN_R2_reg_1 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(1)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(1)
      , R    => OPEN
    );

  i_DIN_R2_reg_2 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(2)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(2)
      , R    => OPEN
    );

  i_DIN_R2_reg_3 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(3)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(3)
      , R    => OPEN
    );

  i_DIN_R2_reg_4 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(4)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(4)
      , R    => OPEN
    );

  i_DIN_R2_reg_5 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(5)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(5)
      , R    => OPEN
    );

  i_DIN_R2_reg_6 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(6)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(6)
      , R    => OPEN
    );

  i_DIN_R2_reg_7 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(7)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(7)
      , R    => OPEN
    );

  i_DIN_R2_reg_8 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(8)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(8)
      , R    => OPEN
    );

  i_DIN_R2_reg_9 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(9)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(9)
      , R    => OPEN
    );

  i_DIN_R2_reg_10 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(10)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(10)
      , R    => OPEN
    );

  i_DIN_R2_reg_11 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(11)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(11)
      , R    => OPEN
    );

  i_DIN_R2_reg_12 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(12)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(12)
      , R    => OPEN
    );

  i_DIN_R2_reg_13 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(13)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(13)
      , R    => OPEN
    );

  i_DIN_R2_reg_14 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(14)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(14)
      , R    => OPEN
    );

  i_DIN_R2_reg_15 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => DIN_R1(15)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DIN_R2(15)
      , R    => OPEN
    );

  i_DOUT_INT_reg_0 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(14)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(0)
      , R    => OPEN
    );

  i_DOUT_INT_reg_1 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(15)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(1)
      , R    => OPEN
    );

  i_DOUT_INT_reg_2 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(16)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(2)
      , R    => OPEN
    );

  i_DOUT_INT_reg_3 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(17)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(3)
      , R    => OPEN
    );

  i_DOUT_INT_reg_4 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(18)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(4)
      , R    => OPEN
    );

  i_DOUT_INT_reg_5 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(19)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(5)
      , R    => OPEN
    );

  i_DOUT_INT_reg_6 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(20)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(6)
      , R    => OPEN
    );

  i_DOUT_INT_reg_7 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(21)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(7)
      , R    => OPEN
    );

  i_DOUT_INT_reg_8 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(22)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(8)
      , R    => OPEN
    );

  i_DOUT_INT_reg_9 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(23)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(9)
      , R    => OPEN
    );

  i_DOUT_INT_reg_10 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(24)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(10)
      , R    => OPEN
    );

  i_DOUT_INT_reg_11 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(25)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(11)
      , R    => OPEN
    );

  i_DOUT_INT_reg_12 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(26)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(12)
      , R    => OPEN
    );

  i_DOUT_INT_reg_13 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(27)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(13)
      , R    => OPEN
    );

  i_DOUT_INT_reg_14 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(28)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(14)
      , R    => OPEN
    );

  i_DOUT_INT_reg_15 : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => FIR_OUT(29)
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => DOUT_INT(15)
      , R    => OPEN
    );

  i_OVF_INT_R_reg : NX_FE
    generic map (
        dff_edge => '0'
      , dff_init => '0'
      , dff_load => '0'
      , dff_mode => '1'
      , dff_sync => '0'
      , lut_table => b"1010101010101010"
    )
    port map (
        CK   => CLK
      , I1   => OVF_INT
      , I2   => OPEN
      , I3   => OPEN
      , I4   => OPEN
      , L    => OPEN
      , O    => OVF_INT_R
      , R    => OPEN
    );

end;

