LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_signed.ALL;

library STD;
use STD.textio.all;
use ieee.std_logic_textio.all;

library nx;
use nx.NXPACKAGE.all;

library work;
use work.NX_SYSTOLIC_FIR_pack.all;

entity TB_TOP_NX_SYSTOLIC_FIR is
end TB_TOP_NX_SYSTOLIC_FIR;

architecture TB of TB_TOP_NX_SYSTOLIC_FIR is 

component TOP_NX_SYSTOLIC_FIR 
Port ( 
   CLK : in  STD_LOGIC;
   SRST : in  STD_LOGIC;
   ENA : in  STD_LOGIC;
   DIN : in  STD_LOGIC_VECTOR (15 downto 0);  -- Input of the first filter
   OVF : out std_logic;
   DOUT : out  STD_LOGIC_VECTOR (15 downto 0)
   );
end component;

signal CLK : std_logic;
signal SRST : std_logic;
signal ENA : std_logic;
signal DIN : std_logic_vector(15 downto 0);

constant ZERO_ARRAY : COEFS_TYPE := (others => (others => '0'));

signal OVF : std_logic;

signal DOUT : std_logic_vector(15 downto 0);

constant ADD_VAL : integer := 153;

begin


TOP_UUT : TOP_NX_SYSTOLIC_FIR 
Port map ( 
   CLK    => CLK,
   SRST   => SRST,
   ENA    => ENA,
   DIN    => DIN,
   OVF    => OVF,
   DOUT   => DOUT
   );

process  begin
   CLK <= '0';  wait for 5 ns;
   CLK <= '1';  wait for 5 ns;
end process;  

ENA <= '1';

process  begin
   SRST <= '1';
   wait for 100 ns;
   SRST <= '0';

   wait;
end process;   

process  begin
   DIN <= (others => '0');
   wait for 150 ns;
   DIN <= (DATA_WIDTH-2 => '1', others => '0');
   wait for 10 ns;
   DIN <= (others => '0');
   wait for 10 ns;
   
   wait for 300 ns;
   
   for I in 1 to 214  loop
      DIN <= DIN + ADD_VAL;
      wait for 10 ns;
   end loop;

   wait for 200 ns;
   DIN <= DIN - 45000;
   wait for 100 ns;
   DIN <= DIN + 45000;
   wait for 200 ns;
   
   for I in 1 to 428  loop
      DIN <= DIN - ADD_VAL;
      wait for 10 ns;
   end loop;

   wait for 200 ns;
   DIN <= DIN + 45000;
   wait for 100 ns;
   DIN <= DIN - 45000;
   wait for 200 ns;
      
   for I in 1 to 214  loop
      DIN <= DIN + ADD_VAL;
      wait for 10 ns;
   end loop;
  
   wait;
end process; 

process
file RESULT_SYSTOLIC : text;
variable LineVar     : line;
variable DinVar      : integer;
variable DoutVar     : integer;
variable OvfVar      : std_logic;
begin
   file_open(RESULT_SYSTOLIC, "RESULT_SYSTOLIC.txt", write_mode);
   for I in 0 to 9999 loop
      wait until rising_edge(CLK);
      DinVar := conv_integer(DIN);
      DoutVar := conv_integer(DOUT);
      OvfVar := OVF;
      write(LineVar, DinVar, right, 12);
      write(LineVar, DoutVar, right, 12);
      write(LineVar, OvfVar, right, 3);
      writeline(RESULT_SYSTOLIC, LineVar);
   end loop;
   file_close(RESULT_SYSTOLIC);
   wait;
end process;

END;
