import os
import sys

from nanoxmap import *

dir = str(os.path.dirname(os.path.realpath(__file__)))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('demo1')

project.addFile('src/demo1.vhd')

project.setOptions({
  'UseNxLibrary': 'Yes'
})

import NX1H35_EK_V1

kit = NX1H35_EK_V1.Kit()

project.addPads({
  'ck_i'    : kit.pad('OSC0')
, 'sw_i[0]' : kit.pad('SW1')
, 'sw_i[1]' : kit.pad('SW2')
, 'sw_i[2]' : kit.pad('SW3')
, 'sw_i[3]' : kit.pad('SW4')
, 'sw_i[4]' : kit.pad('SW5')
, 'sw_i[5]' : kit.pad('SW6')
, 'rst_i'   : kit.pad('PB9')
, 'led_o[0]': kit.pad('LED1')
, 'led_o[1]': kit.pad('LED2')
, 'led_o[2]': kit.pad('LED3')
, 'led_o[3]': kit.pad('LED4')
, 'led_o[4]': kit.pad('LED5')
, 'led_o[5]': kit.pad('LED6')
, 'led_o[6]': kit.pad('LED7')
, 'led_o[7]': kit.pad('LED8')
})

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

#report
project.reportInstances()

#bitstream
project.generateBitstream('demo1.nxb')

project.destroy()

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
