-------------------------------------------------------------------------------
-- Title      : demo1
-- Project    :
-------------------------------------------------------------------------------
-- File       : demo1.vhd
-- Author     : Nanoxplore
-- Company    : Nanoxplore
-- Platform   :
-- Standard   : VHDL'93/02
-------------------------------------------------------------------------------
-- Description:
-------------------------------------------------------------------------------
-- Copyright (c) 2017
-------------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

LIBRARY NX;
use NX.nxPackage.all;

ENTITY demo1 IS
    PORT(
        ck_i    : IN STD_LOGIC;                     -- CLOCK 50 Mhz
        rst_i   : IN STD_LOGIC;                     -- Reset Signal
        sw_i    : IN STD_LOGIC_VECTOR(4 DOWNTO 0);  -- Switches
        led_o   : OUT STD_LOGIC_VECTOR(7 DOWNTO 0)  -- Leds
    );
END demo1;

ARCHITECTURE rtl OF demo1 IS

    SIGNAL prescaler      : UNSIGNED(25 DOWNTO 0);
    SIGNAL out_tmp        : STD_LOGIC_VECTOR(7 DOWNTO 0) ;
    SIGNAL direction      : STD_LOGIC;
    SIGNAL pulse          : STD_LOGIC;
    SIGNAL pulse_tmp      : STD_LOGIC;
    SIGNAL pulse_tmp_reg  : STD_LOGIC;
    SIGNAL pulse_cks_in   : STD_LOGIC;

BEGIN

    PROCESS(ck_i,rst_i)
    BEGIN
      IF(rst_i = '0') THEN
          prescaler <= (OTHERS => '0');
      ELSIF(ck_i'EVENT AND ck_i = '1') THEN
          prescaler <= prescaler + 1;
      END IF;
    END PROCESS;

    PROCESS(pulse,rst_i)
    BEGIN
    IF(rst_i = '0') THEN
      out_tmp    <= "11111111" ;
      direction <= '0';
    ELSIF(pulse'EVENT AND pulse = '1') THEN
      IF(out_tmp = "10000000") THEN
          direction   <= '1';
          out_tmp     <= '0' & out_tmp(7 DOWNTO 1); --SRL
      ELSIF (out_tmp = "00000001") THEN
          direction   <= '0';
          out_tmp     <= out_tmp(6 DOWNTO 0) & '0'; --SLL
      ELSE
          IF(direction = '0') THEN
              out_tmp <= out_tmp(6 DOWNTO 0) & '0'; --SLL
          ELSE
              out_tmp <= '0' & out_tmp(7 DOWNTO 1); --SRL
          END IF;
      END IF;
    END IF;
    END PROCESS ;


    WITH sw_i(4 DOWNTO 0) select pulse_tmp <=
      prescaler(25) WHEN "00001",
      prescaler(24) WHEN "00010",
      prescaler(23) WHEN "00100",
      prescaler(22) WHEN "01000",
      prescaler(21) WHEN "10000",
      prescaler(20) WHEN OTHERS;


    PROCESS(ck_i)
    BEGIN
      IF(ck_i'EVENT AND ck_i = '1') THEN
        pulse_tmp_reg <= pulse_tmp;
      END IF;
    END PROCESS;

    pulse_cks_in <= pulse_tmp and (not pulse_tmp_reg);

    ins_cks_adder: NX_CKS
      port map (
        CKI => ck_i,
        CMD => pulse_cks_in,
        CKO => pulse
      );

    led_o       <= std_logic_vector(out_tmp) ;

END rtl;
