import os
import sys

from os import path
from nanoxmap import *

dir = str(os.path.dirname(os.path.realpath(__file__)))

sys.path.append(dir)

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('enc_dec_lib', 'enc_dec')

project.addFiles('enc_dec_lib', ['src/enc_dec.vhd'])
project.addFiles('enc_lib',['src/seq.vhd', 'src/data_gen.vhd', 'src/enc.vhd'])
project.addFiles('dec_lib', ['src/dec.vhd'])

project.setOptions({'MergeRegisterToPad': 'Always',
                    'MultiplierToDSPMapThreshold': '1',
                    'ManageUnconnectedOutputs': 'Ground',
                    'ManageUnconnectedSignals': 'Ground',
                    'AdderToDSPMapThreshold': '1',
                    'DefaultRAMMapping': 'RAM',
                    'MappingEffort': 'High'})

if path.exists(dir + '/pads.py'):
    from pads import pads
    project.addPads(pads)

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not path.exists(dir + '/pads.py'):
    project.savePorts('pads.py')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

#reports
project.reportInstances()

#STA
analyzer = project.createAnalyzer()

analyzer.launch()

#bitstream
project.generateBitstream('enc_dec.nxb')

project.destroy()

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
