
Library IEEE;
use IEEE.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;
Library enc_lib;
use enc_lib.seq_pkg.all;


entity data_gen is
    generic (N : positive := 32;
	    inst : positive :=5);
    port (
	CLK	: in std_logic;
	RST	: in std_logic;
	ENA	: in std_logic;
	Output	: out std_logic_vector ((N*5)-1 downto 0)
    );
end entity;

architecture rtl of data_gen is
    component seq is
	port (
	    CLK	    : in std_logic;
	    RST	    : in std_logic;
	    ENA	    : in std_logic;
	    Output  : out std_logic_vector (N-1 downto 0)
	);
    end component;
begin
    Gen_seq:
	for i in inst downto 1 generate 
	begin
	    seq_i : seq
	    port map ( CLK, RST, ENA, Output(((i*N)-1) downto((i-1)*N)));
	end generate;
end architecture;
