Library IEEE;
use IEEE.std_logic_1164.all;
use ieee.numeric_std.all;

entity dec is
    generic(
	N 	: positive := 32;
	inst 	: positive := 5
    );
    port(
	CLK	: in std_logic;
	RST	: in std_logic;
	ena 	: in std_logic;
	din 	: in std_logic_vector ((N*inst)-1 downto 0);
	key	: in std_logic_vector (5 downto 0);
	dout	: out std_logic_vector ((N*inst)-1 downto 0)
    );
end entity;

architecture rtl of dec is
    constant step : positive := 20;
begin
    process (CLK, RST, ena, din, key)
	variable temp	: std_logic_vector ((N*inst)-1 downto 0);
    begin
	temp := din;
	if (ena = '1') then
	    for m in 0 to 5 loop 
		if key(m) = '1' then
		   temp (9+(m*step) downto m*step) := not din (9+(m*step) downto m*step);
		else
		    temp (9+(m*step) downto m*step) := din (9+(m*step) downto m*step);
		end if;
	    end loop;
	else
	    temp := (others=>'0');
	end if;
	if CLK'event and CLK ='1' then
	    if RST = '1' then
		dout <= (others => '0');
	    else
		dout <= temp;
	    end if;
	end if;
    end process;
end architecture;
