Library IEEE;
use IEEE.std_logic_1164.all;
use ieee.numeric_std.all;
library enc_lib;
use enc_lib.data_gen;
use enc_lib.enc;
library dec_lib;
use dec_lib.dec;


entity enc_dec is
    generic(
	N    : positive := 32;
	inst : positive := 5
    );
    port (
    	CLK : in std_logic;
	RST : in std_logic;
	ENA : in std_logic;
	dataout	: out std_logic_vector ((N*inst)-1 downto 0)
    );
end entity;

Library enc_dec_lib;
use enc_dec_lib.enc_dec;

architecture rtl of enc_dec is
    signal data_link1 : std_logic_vector ((N*5)-1 downto 0);
    signal data_link2 : std_logic_vector ((N*5)-1 downto 0);
    signal key_link	: std_logic_vector (5 downto 0);
    
    component data_gen is
    	generic (N   : positive;
		inst : positive);
	port (
	    CLK : in std_logic;
	    RST : in std_logic;
	    ENA : in std_logic;
	    Output	: out std_logic_vector ((N*5)-1 downto 0)
	);
    end component;

    component enc is
    	generic(
	   N 	: positive;
	   inst : positive
	);
	port(
	    CLK		: in std_logic;
	    RST		: in std_logic;
	    din 	: in std_logic_vector ((N*inst)-1 downto 0);
	    ena 	: in std_logic;
	    dout	: out std_logic_vector ((N*inst)-1 downto 0);
	    key		: out std_logic_vector (5 downto 0)
	    );
	end component;
	
    component dec is
	generic(
	    N 		: positive;
	    inst 	: positive
	);
	port(
	    din 	: in std_logic_vector ((N*inst)-1 downto 0);
	    ena 	: in std_logic;
	    CLK		: in std_logic;
	    RST		: in std_logic;
	    key		: in std_logic_vector (5 downto 0);
	    dout	: out std_logic_vector ((N*inst)-1 downto 0)
	);
	
    end component;
begin
    UUT1 : data_gen
    generic map(
	N	=> N,
	inst 	=> inst)
    port map(
	CLK => CLK,
	RST => RST,
	ENA => ENA,
	Output => data_link1	
    );
	
    UUT2 : enc
    generic map(
        N 		 => N,
        inst 	 => inst)
    port map(
        CLK => CLK,
        RST	=> RST,
        din => data_link1,
        ENA => ENA,
        dout => data_link2,
        key  => key_link	
    );
	
    UUT3    :	dec
    generic map(
    	N    => N,
	inst => inst)
    port map(
	din => data_link2,
	ENA => ENA,
	CLK => CLK,
	RST	=> RST,
	dout => dataout,
	key  => key_link
    );
end architecture;
