Library IEEE;
use IEEE.std_logic_1164.all;
use ieee.numeric_std.all;

entity enc_dec_tb is
end entity;

architecture rtl of enc_dec_tb is

    component enc_dec is
    	generic(
	    N	 : positive := 32;
	    inst : positive := 5
	);
	port (
	    CLK : in std_logic;
	    RST : in std_logic;
	    ENA : in std_logic;
	    dataout	: out std_logic_vector ((N*inst)-1 downto 0)
	);
    end component;

    signal CLK : std_logic := '0';
    signal RST : std_logic := '0';
    signal ENA : std_logic := '0';
    signal output : std_logic_vector ((32*5)-1 downto 0);

    constant clk_period : time := 2 ns;

begin
    UUT : enc_dec
	generic map (N => 32, inst => 5)
	port map (
	    CLK => CLK,
	    RST => RST,
	    ENA => ENA,
	    dataout => output	
	);
 
	process
	begin
	    CLK <= '0';
	    wait for clk_period/2;
	    CLK <= '1';
	    wait for clk_period/2;
	end process;

	process
	begin
	    wait for 2 ns;
	    RST <= '1';
	    wait for 2 ns;
	    RST <= '0';
	    ENA <= '1';
	    wait;
	end process;

end architecture;
