Library IEEE;
use IEEE.std_logic_1164.all;
use ieee.numeric_std.all;

package seq_pkg is
    component seq is
	generic (N : positive := 32);
	port (
	    CLK	    : in std_logic;
	    RST	    : in std_logic;
	    ENA	    : in std_logic;
	    Output  : out std_logic_vector (N-1 downto 0)
	);
end component;
end package;

package body seq_pkg is
end package body;


Library IEEE;
use IEEE.std_logic_1164.all;
use ieee.numeric_std.all;

entity seq is
    generic (N : positive := 32);
    port (
	CLK	: in std_logic;
	RST	: in std_logic;
	ENA	: in std_logic;
	Output	: out std_logic_vector (N-1 downto 0)
    );
end entity;

architecture rtl of seq is
    signal temp : std_logic_vector (N-1 downto 0);
    type inner_taps is array (32 downto 2) of std_logic_vector (31 downto 0);
    signal taps : inner_taps;

begin
    taps(2)  <= "00000000000000000000000000000001";
    taps(3)  <= "00000000000000000000000000000010";
    taps(4)  <= "00000000000000000000000000000100";
    taps(5)  <= "00000000000000000000000000000100";
    taps(6)  <= "00000000000000000000000000010000";
    taps(7)  <= "00000000000000000000000000100000";
    taps(8)  <= "00000000000000000000000000111000";
    taps(9)  <= "00000000000000000000000000010000";
    taps(10) <= "00000000000000000000000001000000";
    
    taps(11) <= "00000000000000000000000100000000";
    taps(12) <= "00000000000000000000010000101001";
    taps(13) <= "00000000000000000000000000001101";
    taps(14) <= "00000000000000000000000000010101";
    taps(15) <= "00000000000000000010000000000000";
    taps(16) <= "00000000000000000101000000001000";
    taps(17) <= "00000000000000000010000000000000";
    taps(18) <= "00000000000000000000010000000000";
    taps(19) <= "00000000000000000000000000100011";
    taps(20) <= "00000000000000010000000000000000";
    
    taps(21) <= "00000000000001000000000000000000";
    taps(22) <= "00000000000100000000000000000000";
    taps(23) <= "00000000000000100000000000000000";
    taps(24) <= "00000000011000010000000000000000";
    taps(25) <= "00000000001000000000000000000000";
    taps(26) <= "00000000000000000000000000100011";
    taps(27) <= "00000000000000000000000000010011";
    taps(28) <= "00000001000000000000000000000000";
    taps(29) <= "00000100000000000000000000000000";
    taps(30) <= "00000000000000000000000000101001";
    
    taps(31) <= "00001000000000000000000000000000";
    taps(32) <= "00000000001000000000000000000011";


    process (CLK, RST,temp)
	variable feedback : std_logic;
    begin
	if RST = '1' then
	    temp <= (others=> '1');
	    feedback := '1';
	elsif rising_edge (CLK) then
	    if ENA = '1' then
		feedback := temp(0);
		for i in N-2 downto 0 loop
		    if taps(N)(i) = '1' then
			temp(i) <= temp (i+1) xor feedback;
		    else 
			temp(i) <= temp (i+1);
		    end if;
		end loop;
		temp (N-1) <= feedback;
	    end if;
	end if;
	output <= temp;
    end process;
end architecture;



