import os
import sys
import shutil

from nanoxmap import *

sizes = [2, 4, 8, 16]

baseDir = str(os.path.dirname(os.path.realpath(__file__)))

#For each size of the adder, a new project is created then deleted inside a loop

for size in sizes:
    sizeDir = baseDir + '/' + str(size)

    #Remove and create the working directories
    if os.path.exists(sizeDir):
        shutil.rmtree(sizeDir)

    os.mkdir(sizeDir)

    #A project is created with the working directory
    p = createProject(sizeDir)

    p.setVariantName('NG-MEDIUM')

    p.setTopCellName('myadder')

    p.addFile('../src/adder.vhd')

    #Map the adders in CY
    p.addMappingDirective('getModels(add.*)', 'ADD', 'CY')

    #Set generic SIZE for the project
    p.addParameter('SIZE', str(size))

    p.save('native.nxm')

    if 'nativeOnly' in sys.argv:
        p.destroy()

        sys.exit(0)

    if not p.synthesize():
        p.destroy()

        sys.exit(1)

    p.save('synthesized.vhd')
    p.save('synthesized.nxm')

    if not p.place():
        p.destroy()

        sys.exit(1)

    p.save('placed.vhd')
    p.save('placed.nxm')

    if not p.route():
        p.destroy()

        sys.exit(1)

    p.save('routed.vhd')
    p.save('routed.nxm')

    p.generateBitstream('myadder.nxb')

    #Project destruction
    p.destroy()

