import os
import sys

from nanoxmap import *

dir = str(os.path.dirname(os.path.realpath(__file__)))



##                                                                                                ##
## First project creation                                                                         ##
##                                                                                                ##

project = createProject(dir + '/method')

project.setVariantName('NG-MEDIUM')

project.setTopCellName('my_rom')

project.addFile('../src/method.vhd')

project.addMemoryInitialization('getModels(my_rom_rom)', 'NX', '../src/init.txt')

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

project.generateBitstream('method.nxb')

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()

project.destroy()



##                                                                                                ##
## Second project creation                                                                        ##
##                                                                                                ##

project = createProject(dir + '/attribute')

project.setVariantName('NG-MEDIUM')

project.setTopCellName('my_rom')

project.addFile('../src/attribute.vhd')

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

project.generateBitstream('attribute.nxb')

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()

project.destroy()
