LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

entity my_rom is
  generic (
    DATA_WIDTH : integer:=5;
    NOLINES : integer:= 6
    );
  port (
    clk       : in std_logic;
    data_out  : out std_logic_vector(DATA_WIDTH-1 downto 0)
	);
end my_rom;

architecture syn of my_rom is

type mem_array is array(0 to NOLINES-1) of std_logic_vector(DATA_WIDTH-1 downto 0);

signal rom	    : mem_array;

attribute NX_INIT :string;
attribute NX_INIT of rom: signal is "../src/init.txt";

signal data_out_reg : std_logic_vector(DATA_WIDTH-1 downto 0) := (others => '0');

begin
    process (clk)
    variable currentLine : integer :=0;

    begin
        if (clk'event and clk = '1') then
          data_out_reg <= rom(currentLine);

	  currentLine := currentLine + 1;

	  if currentLine = NOLINES then
	    currentLine :=0;
	  end if;
        end if;
    end process;
   data_out <= data_out_reg;

end syn;
