import os
import sys

from nanoxmap import *

dir = str(os.path.dirname(os.path.realpath(__file__)))

project = createProject(dir)

project.setVariantName('NG-MEDIUM')

project.setTopCellName('simple')

project.addFile('src/simple.vhd')

project.setOption('MappingEffort', 'Medium')

project.addPad('I1',   { 'location': 'IO_B0D02P', 'type': 'LVCMOS_2.5V_2mA'})
project.addPad('I2',   { 'location': 'IO_B0D03P', 'type': 'LVCMOS_2.5V_2mA'})
project.addPad('I3',   { 'location': 'IO_B0D04P', 'type': 'LVCMOS_2.5V_2mA'})
project.addPad('CK1',  { 'location': 'IO_B9D08P', 'type': 'LVCMOS_2.5V_2mA'})
project.addPad('CK2',  { 'location': 'IO_B9D09P', 'type': 'LVCMOS_2.5V_2mA'})
project.addPad('O[0]', { 'location': 'IO_B8D02P', 'type': 'LVCMOS_2.5V_2mA',
                         'outputDelayLine': 5,
                         'differential': False, 'weakTermination': 'None'})
project.addPad('O[1]', { 'location': 'IO_B8D03P', 'type': 'LVCMOS_2.5V_2mA',
                         'outputDelayLine': 5,
                         'differential': False, 'weakTermination': 'None'})
project.addPad('O[2]', { 'location': 'IO_B8D04P', 'type': 'LVCMOS_2.5V_2mA',
                         'outputDelayLine': 5,
                         'differential': False, 'weakTermination': 'None'})

project.save('native.nxm')

if not project.synthesize():
    sys.exit(1)

project.save('synthesized.nxm')

if not project.place():
    sys.exit(1)

project.reportPorts()

project.save('placed.nxm')

if not project.route():
    sys.exit(1)

project.save('routed.nxm')

project.reportInstances()

#STA
analyzer = project.createAnalyzer()

analyzer.launch()

#bitstream
project.generateBitstream('simple.nxb')

project.destroy()

print 'Errors: ', getErrorCount()
print 'Warnings: ', getWarningCount()
