--                                                                                                --
-- File: simple.vhd                                                                               --
--                                                                                                --

library ieee;
use ieee.std_logic_1164.all;

entity simple is
port (
    I1  : in  std_logic;
    I2  : in  std_logic;
    I3  : in  std_logic;
    CK1 : in  std_logic;
    CK2 : in  std_logic;
    O   : out std_logic_vector(2 downto 0)
);
end simple;

architecture behavioral of simple is
signal temp1, temp2, temp3: std_logic;
begin
    process(CK1)
    begin
        if (rising_edge(CK1)) then
            temp1 <= I1;
            temp2 <= I2;
            O(0) <= temp1 and temp2 and temp3;
        end if;
    end process;

    process(CK1)
    begin
        if (falling_edge(CK1)) then
            O(1) <= temp1 or temp2 or temp3;
        end if;
    end process;

    process(CK2)
    begin
        if (rising_edge(CK2)) then
            temp3 <= I3;
            O(2) <= temp1 xor temp2 xor temp3;
        end if;
    end process;

end behavioral;
