import os
import sys

from os import path
from os import symlink
from nanoxmap import *

baseDir = path.dirname(path.realpath(__file__))

sys.path.append(baseDir)

p = createProject(baseDir)

p.setVariantName('NG-MEDIUM')

p.setTopCellName('dec_mem')

p.addFile('src/test_unequal.vhd')

p.addMappingDirective('getModels(dec_mem_.*)', 'RAM', 'RAM')

p.addMemoryInitialization('getModels(dec_mem_mem_R)', 'NX', 'src/init_R.bin')

p.addParameters({'M_ADD': '10'
               , 'M_MEM': '1024'
               , 'M_DAT': '8' })

p.synthesize()

p.save("synthesized_mem.vhd")

