library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

--library NX;
--use NX.nxPackage.all;

entity dec_mem is
generic (
    M_ADD : integer;	-- := 10;
    M_MEM : integer;	-- := 1024;
    M_DAT : integer	-- := 8
);
port (
  CLK1 : in  std_logic;
  CLK2 : in  std_logic;
  ADD1 : in  std_logic_vector((  M_ADD - 1) downto 0);
  ADD2 : in  std_logic_vector((  M_ADD - 2) downto 0);
  DI1  : in  std_logic_vector((  M_DAT - 1) downto 0);
  DI2  : in  std_logic_vector((2*M_DAT - 1) downto 0);
  DO1  : out std_logic_vector((  M_DAT - 1) downto 0);
  DO2  : out std_logic_vector((2*M_DAT - 1) downto 0);
  RE1  : in  std_logic;
  RE2  : in  std_logic;
  WE1  : in  std_logic;
  WE2  : in  std_logic
);
end dec_mem;

-- Design

architecture behavioral of dec_mem is

  signal DOB1 : std_logic_vector((  M_DAT - 1) downto 0);
  signal DOB2 : std_logic_vector((2*M_DAT - 1) downto 0);

  -- Infered Signals

  type mem_array is array(0 to (M_MEM - 1)) of std_logic_vector((M_DAT - 1) downto 0);

  signal mem_R : mem_array;

  begin

  DO1 <= DOB1;
  DO2 <= DOB2;

process (CLK1, CLK2) 
begin

  if rising_edge(CLK1) then
    if WE1 = '1' then
      mem_R(to_integer(unsigned(ADD1))) <= DI1;
    end if;
    if RE1 = '1' then
      DOB1 <= mem_R(to_integer(unsigned(ADD1)));
    end if;
  end if;

  if rising_edge(CLK2) then
    if WE2 = '1' then
      mem_R(to_integer(unsigned(ADD2 & '0')))   <= DI2((  M_DAT - 1) downto 0);
      mem_R(to_integer(unsigned(ADD2 & '1'))) <= DI2((2*M_DAT - 1) downto M_DAT);
    end if;
    if RE2 = '1' then
      DOB2((  M_DAT - 1) downto     0) <= mem_R(to_integer(unsigned(ADD2 & '0')));
      DOB2((2*M_DAT - 1) downto M_DAT) <= mem_R(to_integer(unsigned(ADD2 & '1')));
    end if;
  end if;

end process;

end behavioral;
