-- =================================================================================================
--   IP_FIFO_part definition                                                             2018/07/19
-- =================================================================================================
-- This IP is dedicated only for NG-MEDIUM variants

library ieee;
use ieee.std_logic_1164.all;

library NX;
use NX.nxPackage.all;

entity IP_FIFO_part is
generic (
    almost_full_margin  : integer range 0 to 60 := 4;
    almost_empty_margin : integer range 0 to 60 := 5
);
port (
    WCK		: in std_logic;			-- Write clock
    RCK		: in std_logic;			-- Read clock
    RST		: in std_logic;			-- RST (internally resynchronized on WCK and RCK)
    WE		: in std_logic;			-- Write Enable
    RE		: in std_logic;			-- Read Enable
    DIN		: in std_logic_vector(15 downto 0);	-- Data input
    DOUT	: out std_logic_vector(15 downto 0);	-- Data output
    FULL	: out std_logic;		-- '1' when FIFO is FULL
    ALMOST_FULL	: out std_logic;		-- '1' when FIFO is ALMOST_FULL (margin set to 2)
    EMPTY	: out std_logic;		-- '1' when FIFO is EMPTY
    ALMOST_EMPTY: out std_logic;		-- '1' when FIFO is ALMOST_EMPTY
    WR_ACK	: out std_logic;		-- Returns '1' when Write is accepted
    RD_ACK	: out std_logic			-- Returns '1' when Read is valid
);
end IP_FIFO_part;

`protect begin_protected
`protect version = 1
`protect encrypt_agent = "NanoXplore"
`protect key_keyowner = "NanoXplore", key_keyname = "NX-IP-RSA-1", key_method = "rsa"
`protect encoding = (enctype = "base64", line_length = 64, bytes = 128)
`protect key_block
XZr4qytOhllPkxnovTXonk1L33Tu+tRR0u4OS/aCJc5hHQ1UbSEBUas47ru57qYB
ES46uTuDLhdORPgqjLcAEdG/2sA2PTAmIa4s5w+xlKETBrhrXyy/e8GBl2tfJMQi
06KO3zwDjxIniU5n4nYUBRIHkPlmKNS58XvRxXsVU4k=
`protect key_keyowner = "Mentor Graphics Corporation", key_keyname = "MGC-VERIF-SIM-RSA-1", key_method = "rsa"
`protect encoding = (enctype = "base64", line_length = 64, bytes = 128)
`protect key_block
G7vrGGSvlmo5BYTxFp//OareKpLN102vwE5q4JPZ3IQAuPNzLtuoGsSc4uxIx4d3
ylVGawzVPbJTxSqPm0teYE5plRovs11M7+EE+pNsvH0HRxIwmXMABEImd7NfI99F
WNJB5p7+9pSJ/UdyXJBm+43n07u/dXKIOf7wASznpPc=
`protect data_method = "aes128-cbc"
`protect encoding = (enctype = "base64", line_length = 64, bytes = 9888)
`protect data_block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`protect end_protected

