##                                                                                                ##
## Copyright (C) 2010-2018 NanoXplore. All Rights Reserved.                                       ##
##                                                                                                ##
## This file contains the base definition of the kit Python class.                                ##
##                                                                                                ##
## Do not edit after this file.                                                                   ##
##                                                                                                ##

class BaseKit:
    def __init__(self):
        self.pads = {}

        self.interfaces = {}

    def pad(self, name):
        name = name.lower()

        if name in self.pads:
            return self.pads[name]
        elif name in self.interfaces:
            raise ValueError(name + ' is not a pad but an interface.')
        else:
            raise ValueError('Could not find ' + name)

    def location(self, name):
        return self.pad(name)['location']

    def type(self, name):
        return self.pad(name)['type']

    def interface(self, name):
        name = name.lower()

        if name in self.interfaces:
            return self.interfaces[name]
        elif name in self.pads:
            raise ValueError(name + ' is not an interface but a pad.')
        else:
            raise ValueError('Could not find ' + name)

##                                                                                                ##
## End of file                                                                                    ##
##                                                                                                ##
