##                                                                                                ##
## Copyright (C) 2010-2018 NanoXplore. All Rights Reserved.                                       ##
##                                                                                                ##
## This file contains the pads definition for NX1H35 development kit board DK625V1.               ##
##                                                                                                ##

from BaseKit import BaseKit

class Kit(BaseKit):
    def __init__(self):
        BaseKit.__init__(self) # Class initialization, do not remove

        # Pads definition. You can edit this to fit your custom board.
        # Clock sources
        self.pads['osc0']   = {'location': 'IOB12_D09P', 'type': 'LVCMOS_2.5V_2mA'} # Standard 50MHz clock oscillator
        self.pads['osc1']   = {'location': 'IOB12_D08P', 'type': 'LVCMOS_2.5V_2mA'} # Socket-mounted clock oscillator
        self.pads['sma0']   = {'location': 'IOB0_D10P', 'type': 'LVCMOS_3.3V_2mA'}  # External J8 SMA clock input
        self.pads['sma1']   = {'location': 'IOB0_D11P', 'type': 'LVCMOS_3.3V_2mA'}  # External J9 SMA clock input

        # Switches and Pushbuttons
        self.pads['sw1']    = {'location': 'IOB10_D09P', 'type': 'LVCMOS_1.8V_2mA'} # PA09 (Switch S1)
        self.pads['sw2']    = {'location': 'IOB10_D03P', 'type': 'LVCMOS_1.8V_2mA'} # PA03 (Switch S2)
        self.pads['sw3']    = {'location': 'IOB10_D03N', 'type': 'LVCMOS_1.8V_2mA'} # NA03 (Switch S3)
        self.pads['sw4']    = {'location': 'IOB10_D04P', 'type': 'LVCMOS_1.8V_2mA'} # PA04 (Switch S4)
        self.pads['sw5']    = {'location': 'IOB10_D09N', 'type': 'LVCMOS_1.8V_2mA'} # NA09 (Switch S5)
        self.pads['sw6']    = {'location': 'IOB10_D04N', 'type': 'LVCMOS_1.8V_2mA'} # NA04 (Switch S6)
        self.pads['pb8']    = {'location': 'IOB10_D07P', 'type': 'LVCMOS_1.8V_2mA'} # PA07 (Pushbutton S8)
        self.pads['pb9']    = {'location': 'IOB10_D12P', 'type': 'LVCMOS_1.8V_2mA'} # PA12 (Pushbutton S9)
        self.pads['pb10']   = {'location': 'IOB10_D07N', 'type': 'LVCMOS_1.8V_2mA'} # NA07 (Pushbutton S10)
        self.pads['pb11']   = {'location': 'IOB10_D12N', 'type': 'LVCMOS_1.8V_2mA'} # NA12 (Pushbutton S11)
        self.pads['pb12']   = {'location': 'IOB10_D14P', 'type': 'LVCMOS_1.8V_2mA'} # PA14 (Pushbutton S12)

        # User LEDs
        self.pads['led1']   = {'location': 'IOB0_D01P', 'type': 'LVCMOS_3.3V_2mA'}  # LED1
        self.pads['led2']   = {'location': 'IOB0_D03N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['led3']   = {'location': 'IOB0_D03P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['led4']   = {'location': 'IOB1_D05N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['led5']   = {'location': 'IOB1_D05P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['led6']   = {'location': 'IOB1_D06N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['led7']   = {'location': 'IOB1_D06P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['led8']   = {'location': 'IOB1_D02N', 'type': 'LVCMOS_3.3V_2mA'}  # LED8

        # TP1 & TP2: Bank0 spare I/Os
        self.pads['n001']   = {'location': 'IOB0_D01N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['n002']   = {'location': 'IOB0_D02N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['n004']   = {'location': 'IOB0_D04N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['n005']   = {'location': 'IOB0_D05N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['n006']   = {'location': 'IOB0_D06N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['n007']   = {'location': 'IOB0_D07N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['n008']   = {'location': 'IOB0_D08N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['n009']   = {'location': 'IOB0_D09N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['n010']   = {'location': 'IOB0_D10N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['n011']   = {'location': 'IOB0_D11N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['p002']   = {'location': 'IOB0_D02P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['p004']   = {'location': 'IOB0_D04P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['p005']   = {'location': 'IOB0_D05P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['p006']   = {'location': 'IOB0_D06P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['p007']   = {'location': 'IOB0_D07P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['p008']   = {'location': 'IOB0_D08P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['p009']   = {'location': 'IOB0_D09P', 'type': 'LVCMOS_3.3V_2mA'}

        # TP3 & TP4: Bank12 spare I/Os
        self.pads['nc01']   = {'location': 'IOB12_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['nc02']   = {'location': 'IOB12_D02N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['nc07']   = {'location': 'IOB12_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['nc08']   = {'location': 'IOB12_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['nc09']   = {'location': 'IOB12_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['nc14']   = {'location': 'IOB12_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['nc15']   = {'location': 'IOB12_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['pc01']   = {'location': 'IOB12_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['pc02']   = {'location': 'IOB12_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['pc07']   = {'location': 'IOB12_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['pc14']   = {'location': 'IOB12_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['pc15']   = {'location': 'IOB12_D15P', 'type': 'LVCMOS_2.5V_2mA'}

        # TP5: Bank5 spare I/Os
        self.pads['n501']   = {'location': 'IOB5_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['n503']   = {'location': 'IOB5_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['n505']   = {'location': 'IOB5_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['p501']   = {'location': 'IOB5_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['p503']   = {'location': 'IOB5_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['p505']   = {'location': 'IOB5_D05P', 'type': 'LVCMOS_2.5V_2mA'}

        # TP1 & TP2: Bank0 spare I/Os
        self.pads['tp1_2']  = {'location': 'IOB0_D06P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp1_3']  = {'location': 'IOB0_D07P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp1_4']  = {'location': 'IOB0_D05P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp1_5']  = {'location': 'IOB0_D09P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp1_6']  = {'location': 'IOB0_D01N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp1_7']  = {'location': 'IOB0_D08P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp1_8']  = {'location': 'IOB0_D10N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp1_9']  = {'location': 'IOB0_D02N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp1_10'] = {'location': 'IOB0_D04N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp2_2']  = {'location': 'IOB0_D06N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp2_3']  = {'location': 'IOB0_D07N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp2_4']  = {'location': 'IOB0_D05N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp2_5']  = {'location': 'IOB0_D09N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp2_6']  = {'location': 'IOB0_D11N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp2_7']  = {'location': 'IOB0_D08N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp2_8']  = {'location': 'IOB0_D02P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['tp2_9']  = {'location': 'IOB0_D04P', 'type': 'LVCMOS_3.3V_2mA'}

        # TP3 & TP4: Bank12 spare I/Os
        self.pads['tp3_2']  = {'location': 'IOB12_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp3_3']  = {'location': 'IOB12_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp3_4']  = {'location': 'IOB12_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp3_5']  = {'location': 'IOB12_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp3_6']  = {'location': 'IOB12_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp3_7']  = {'location': 'IOB12_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp4_2']  = {'location': 'IOB12_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp4_3']  = {'location': 'IOB12_D15P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp4_4']  = {'location': 'IOB12_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp4_5']  = {'location': 'IOB12_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp4_6']  = {'location': 'IOB12_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp4_7']  = {'location': 'IOB12_D02N', 'type': 'LVCMOS_2.5V_2mA'}

        # TP5: Bank5 spare I/Os
        self.pads['tp5_2']  = {'location': 'IOB5_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp5_3']  = {'location': 'IOB5_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp5_4']  = {'location': 'IOB5_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp5_5']  = {'location': 'IOB5_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp5_6']  = {'location': 'IOB5_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['tp5_7']  = {'location': 'IOB5_D05P', 'type': 'LVCMOS_2.5V_2mA'}

        # J7 FMC interface
        self.pads['fclk0n'] = {'location': 'IOB9_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fclk0p'] = {'location': 'IOB9_D09P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fclk1n'] = {'location': 'IOB9_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fclk1p'] = {'location': 'IOB9_D08P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha00n'] = {'location': 'IOB6_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha00p'] = {'location': 'IOB6_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha01n'] = {'location': 'IOB6_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha01p'] = {'location': 'IOB6_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha02n'] = {'location': 'IOB7_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha02p'] = {'location': 'IOB7_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha03n'] = {'location': 'IOB7_D12N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha03p'] = {'location': 'IOB7_D12P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha04n'] = {'location': 'IOB7_D11N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha04p'] = {'location': 'IOB7_D11P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha05n'] = {'location': 'IOB6_D13N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha05p'] = {'location': 'IOB6_D13P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha06n'] = {'location': 'IOB7_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha06p'] = {'location': 'IOB7_D08P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha07n'] = {'location': 'IOB6_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha07p'] = {'location': 'IOB6_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha08n'] = {'location': 'IOB7_D06N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha08p'] = {'location': 'IOB7_D06P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha09n'] = {'location': 'IOB6_D02N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha09p'] = {'location': 'IOB6_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha10n'] = {'location': 'IOB8_D11N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha10p'] = {'location': 'IOB8_D11P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha11n'] = {'location': 'IOB8_D12N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha11p'] = {'location': 'IOB8_D12P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha12n'] = {'location': 'IOB7_D04N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha12p'] = {'location': 'IOB7_D04P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha13n'] = {'location': 'IOB6_D06N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha13p'] = {'location': 'IOB6_D06P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha14n'] = {'location': 'IOB7_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha14p'] = {'location': 'IOB7_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha15n'] = {'location': 'IOB8_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha15p'] = {'location': 'IOB8_D09P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha16n'] = {'location': 'IOB7_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha16p'] = {'location': 'IOB7_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha17n'] = {'location': 'IOB8_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha17p'] = {'location': 'IOB8_D15P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha18n'] = {'location': 'IOB9_D10N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha18p'] = {'location': 'IOB9_D10P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha19n'] = {'location': 'IOB7_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha19p'] = {'location': 'IOB7_D05P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha20n'] = {'location': 'IOB7_D13N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha20p'] = {'location': 'IOB7_D13P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha21n'] = {'location': 'IOB9_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha21p'] = {'location': 'IOB9_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha22n'] = {'location': 'IOB9_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha22p'] = {'location': 'IOB9_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha23n'] = {'location': 'IOB9_D06N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fha23p'] = {'location': 'IOB9_D06P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla00n'] = {'location': 'IOB6_D11N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla00p'] = {'location': 'IOB6_D11P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla01n'] = {'location': 'IOB6_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla01p'] = {'location': 'IOB6_D08P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla02n'] = {'location': 'IOB6_D12N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla02p'] = {'location': 'IOB6_D12P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla03n'] = {'location': 'IOB7_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla03p'] = {'location': 'IOB7_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla04n'] = {'location': 'IOB7_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla04p'] = {'location': 'IOB7_D09P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla05n'] = {'location': 'IOB6_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla05p'] = {'location': 'IOB6_D15P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla06n'] = {'location': 'IOB6_D10N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla06p'] = {'location': 'IOB6_D10P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla07n'] = {'location': 'IOB8_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla07p'] = {'location': 'IOB8_D08P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla08n'] = {'location': 'IOB7_D02N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla08p'] = {'location': 'IOB7_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla09n'] = {'location': 'IOB6_D04N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla09p'] = {'location': 'IOB6_D04P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla10n'] = {'location': 'IOB6_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla10p'] = {'location': 'IOB6_D09P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla11n'] = {'location': 'IOB8_D06N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla11p'] = {'location': 'IOB8_D06P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla12n'] = {'location': 'IOB8_D10N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla12p'] = {'location': 'IOB8_D10P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla13n'] = {'location': 'IOB6_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla13p'] = {'location': 'IOB6_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla14n'] = {'location': 'IOB6_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla14p'] = {'location': 'IOB6_D05P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla15n'] = {'location': 'IOB8_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla15p'] = {'location': 'IOB8_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla16n'] = {'location': 'IOB8_D13N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla16p'] = {'location': 'IOB8_D13P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla17n'] = {'location': 'IOB7_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla17p'] = {'location': 'IOB7_D15P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla18n'] = {'location': 'IOB7_D10N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla18p'] = {'location': 'IOB7_D10P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla19n'] = {'location': 'IOB9_D04N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla19p'] = {'location': 'IOB9_D04P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla20n'] = {'location': 'IOB8_D04N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla20p'] = {'location': 'IOB8_D04P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla21n'] = {'location': 'IOB9_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla21p'] = {'location': 'IOB9_D15P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla22n'] = {'location': 'IOB9_D02N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla22p'] = {'location': 'IOB9_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla23n'] = {'location': 'IOB8_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla23p'] = {'location': 'IOB8_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla24n'] = {'location': 'IOB9_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla24p'] = {'location': 'IOB9_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla25n'] = {'location': 'IOB9_D12N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla25p'] = {'location': 'IOB9_D12P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla26n'] = {'location': 'IOB8_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla26p'] = {'location': 'IOB8_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla27n'] = {'location': 'IOB8_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla27p'] = {'location': 'IOB8_D05P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla28n'] = {'location': 'IOB9_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla28p'] = {'location': 'IOB9_D05P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla29n'] = {'location': 'IOB8_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla29p'] = {'location': 'IOB8_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla30n'] = {'location': 'IOB9_D11N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla30p'] = {'location': 'IOB9_D11P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla31n'] = {'location': 'IOB8_D02N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla31p'] = {'location': 'IOB8_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla32n'] = {'location': 'IOB9_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla32p'] = {'location': 'IOB9_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla33n'] = {'location': 'IOB9_D13N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fla33p'] = {'location': 'IOB9_D13P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['fpgc2m'] = {'location': 'IOB1_D04P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['fpgm2c'] = {'location': 'IOB1_D04N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['fps_n' ] = {'location': 'IOB1_D10N', 'type': 'LVCMOS_3.3V_2mA'} # FMC Presence detect
        self.pads['fscl'  ] = {'location': 'IOB1_D09P', 'type': 'LVCMOS_3.3V_2mA'} # FMC I2C
        self.pads['fsda'  ] = {'location': 'IOB1_D09N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['ftrn'  ] = {'location': 'IOB1_D10P', 'type': 'LVCMOS_3.3V_2mA'} # FMC JTAG
        self.pads['ftms'  ] = {'location': 'IOB1_D11P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['ftck'  ] = {'location': 'IOB1_D01N', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['ftdi'  ] = {'location': 'IOB1_D01P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['ftdo'  ] = {'location': 'IOB1_D11N', 'type': 'LVCMOS_3.3V_2mA'}

        # J6 HSMC interface
        self.pads['hcki0']  = {'location': 'IOB5_D08P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hcko0']  = {'location': 'IOB5_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd0n']   = {'location': 'IOB3_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd0p']   = {'location': 'IOB3_D05P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd1n ']  = {'location': 'IOB3_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd1p ']  = {'location': 'IOB3_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd2n']   = {'location': 'IOB3_D04N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd2p']   = {'location': 'IOB3_D04P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd3n']   = {'location': 'IOB3_D13N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd3p']   = {'location': 'IOB3_D13P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd4n']   = {'location': 'IOB3_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd4p']   = {'location': 'IOB3_D09P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd5n']   = {'location': 'IOB3_D15P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd5p']   = {'location': 'IOB3_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd6n']   = {'location': 'IOB2_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd6p']   = {'location': 'IOB2_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd7n']   = {'location': 'IOB2_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd7p']   = {'location': 'IOB2_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd8n']   = {'location': 'IOB2_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd8p']   = {'location': 'IOB2_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd9n']   = {'location': 'IOB2_D04N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd9p']   = {'location': 'IOB2_D04P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd10n']  = {'location': 'IOB2_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd10p']  = {'location': 'IOB2_D09P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd11n']  = {'location': 'IOB2_D10N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd11p']  = {'location': 'IOB2_D10P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd12n']  = {'location': 'IOB2_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd12p']  = {'location': 'IOB2_D08P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd13n']  = {'location': 'IOB2_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd13p']  = {'location': 'IOB2_D15P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd14n']  = {'location': 'IOB5_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd14p']  = {'location': 'IOB5_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd15n']  = {'location': 'IOB5_D11N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd15p']  = {'location': 'IOB5_D11P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd16n']  = {'location': 'IOB5_D12N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd16p']  = {'location': 'IOB5_D12P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd17n']  = {'location': 'IOB5_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd17p']  = {'location': 'IOB5_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd18n']  = {'location': 'IOB4_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd18p']  = {'location': 'IOB4_D08P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd19n']  = {'location': 'IOB4_D02N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd19p']  = {'location': 'IOB4_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd20n']  = {'location': 'IOB4_D10N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd20p']  = {'location': 'IOB4_D10P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd21n']  = {'location': 'IOB4_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd21p']  = {'location': 'IOB4_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd22n']  = {'location': 'IOB4_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd22p']  = {'location': 'IOB4_D09P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd23n']  = {'location': 'IOB4_D13N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd23p']  = {'location': 'IOB4_D13P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd24n']  = {'location': 'IOB3_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd24p']  = {'location': 'IOB3_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd25n']  = {'location': 'IOB4_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd25p']  = {'location': 'IOB4_D15P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd26n']  = {'location': 'IOB3_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd26p']  = {'location': 'IOB3_D02N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd27n']  = {'location': 'IOB4_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd27p']  = {'location': 'IOB4_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd28n']  = {'location': 'IOB3_D08N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd28p']  = {'location': 'IOB3_D08P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd29n']  = {'location': 'IOB3_D07N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd29p']  = {'location': 'IOB3_D07P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd30n']  = {'location': 'IOB3_D11N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd30p']  = {'location': 'IOB3_D11P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd31n']  = {'location': 'IOB3_D12N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd31p']  = {'location': 'IOB3_D12P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd32n']  = {'location': 'IOB2_D02N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd32p']  = {'location': 'IOB2_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd33n']  = {'location': 'IOB3_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd33p']  = {'location': 'IOB3_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd34n']  = {'location': 'IOB2_D06N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd34p']  = {'location': 'IOB2_D06P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd35n']  = {'location': 'IOB2_D11N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd35p']  = {'location': 'IOB2_D11P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd36n']  = {'location': 'IOB2_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd36p']  = {'location': 'IOB2_D05P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd37n']  = {'location': 'IOB2_D12N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd37p']  = {'location': 'IOB2_D12P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd38n']  = {'location': 'IOB2_D14N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd38p']  = {'location': 'IOB2_D14P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd39n']  = {'location': 'IOB2_D13N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hd39p']  = {'location': 'IOB2_D13P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx0n']  = {'location': 'IOB3_D10N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx0p']  = {'location': 'IOB3_D10P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx1n']  = {'location': 'IOB4_D06N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx1p']  = {'location': 'IOB4_D06P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx2n']  = {'location': 'IOB4_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx2p']  = {'location': 'IOB4_D05P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx3n']  = {'location': 'IOB4_D04N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx3p']  = {'location': 'IOB4_D04P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx4n']  = {'location': 'IOB5_D13N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx4p']  = {'location': 'IOB5_D13P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx5n']  = {'location': 'IOB5_D10N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx5p']  = {'location': 'IOB5_D10P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx6n']  = {'location': 'IOB5_D04N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx6p']  = {'location': 'IOB5_D04P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx7n']  = {'location': 'IOB5_D02N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hrx7p']  = {'location': 'IOB5_D02P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx0n']  = {'location': 'IOB3_D06N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx0p']  = {'location': 'IOB3_D06P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx1n']  = {'location': 'IOB4_D11N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx1p']  = {'location': 'IOB4_D11P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx2n']  = {'location': 'IOB4_D12N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx2p']  = {'location': 'IOB4_D12P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx3n']  = {'location': 'IOB4_D01N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx3p']  = {'location': 'IOB4_D01P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx4n']  = {'location': 'IOB4_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx4p']  = {'location': 'IOB4_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx5n']  = {'location': 'IOB5_D15N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx5p']  = {'location': 'IOB5_D15P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx6n']  = {'location': 'IOB5_D09N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx6p']  = {'location': 'IOB5_D09P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx7n']  = {'location': 'IOB5_D06N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['htx7p']  = {'location': 'IOB5_D06P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['hscl']   = {'location': 'IOB1_D08N', 'type': 'LVCMOS_3.3V_2mA'} # HSMC I2C
        self.pads['hsda']   = {'location': 'IOB1_D02P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['htms']   = {'location': 'IOB1_D07N', 'type': 'LVCMOS_3.3V_2mA'} # HSMC JTAG
        self.pads['htck']   = {'location': 'IOB1_D03P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['htdi']   = {'location': 'IOB1_D07P', 'type': 'LVCMOS_3.3V_2mA'}
        self.pads['htdo']   = {'location': 'IOB1_D03N', 'type': 'LVCMOS_3.3V_2mA'}

        # Micron MT47H128M16 DDR2 SDRAM
        self.pads['mcke']   = {'location': 'IOB10_D05P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mckn ']  = {'location': 'IOB11_D09P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mckp ']  = {'location': 'IOB11_D09N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mcsn']   = {'location': 'IOB11_D08P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mcasn']  = {'location': 'IOB10_D06P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mrasn']  = {'location': 'IOB10_D11N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mwen']   = {'location': 'IOB10_D11P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mldm']   = {'location': 'IOB11_D06P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mudm']   = {'location': 'IOB11_D14P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['modt']   = {'location': 'IOB11_D08N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['ldqsn']  = {'location': 'IOB11_D03N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['ldqsp']  = {'location': 'IOB11_D03P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['udqsn']  = {'location': 'IOB11_D13N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['udqsp']  = {'location': 'IOB11_D13P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad0']   = {'location': 'IOB11_D10P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad1']   = {'location': 'IOB10_D01P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad2']   = {'location': 'IOB10_D15N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad3']   = {'location': 'IOB10_D10N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad4']   = {'location': 'IOB11_D07P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad5']   = {'location': 'IOB10_D08N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad6']   = {'location': 'IOB10_D15P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad7']   = {'location': 'IOB10_D10P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad8']   = {'location': 'IOB11_D07N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad9']   = {'location': 'IOB10_D08P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad10']  = {'location': 'IOB10_D02N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad11']  = {'location': 'IOB10_D13N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad12']  = {'location': 'IOB10_D14N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad13']  = {'location': 'IOB10_D06N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad14']  = {'location': 'IOB11_D06N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mad15']  = {'location': 'IOB10_D13P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mba0']   = {'location': 'IOB10_D05N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mba1']   = {'location': 'IOB10_D01N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mba2']   = {'location': 'IOB10_D02P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq0']   = {'location': 'IOB11_D01N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq1']   = {'location': 'IOB11_D02N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq2']   = {'location': 'IOB11_D05N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq3']   = {'location': 'IOB11_D02P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq4']   = {'location': 'IOB11_D04P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq5']   = {'location': 'IOB11_D05P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq6']   = {'location': 'IOB11_D04N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq7']   = {'location': 'IOB11_D01P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq8']   = {'location': 'IOB11_D12P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq9']   = {'location': 'IOB11_D10N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq10']  = {'location': 'IOB11_D12N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq11']  = {'location': 'IOB11_D14N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq12']  = {'location': 'IOB11_D15P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq13']  = {'location': 'IOB11_D11P', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq14']  = {'location': 'IOB11_D15N', 'type': 'LVCMOS_1.8V_2mA'}
        self.pads['mdq15']  = {'location': 'IOB11_D11N', 'type': 'LVCMOS_1.8V_2mA'}

        # J4 User1 SpaceWire
        self.pads['u1din']  = {'location': 'IOB12_D03N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u1dip']  = {'location': 'IOB12_D03P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u1sin']  = {'location': 'IOB12_D04N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u1sip']  = {'location': 'IOB12_D04P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u1don']  = {'location': 'IOB12_D05N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u1dop']  = {'location': 'IOB12_D05P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u1son']  = {'location': 'IOB12_D06N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u1sop']  = {'location': 'IOB12_D06P', 'type': 'LVCMOS_2.5V_2mA'}

        # J5 User2 SpaceWire
        self.pads['u2din']  = {'location': 'IOB12_D13N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u2dip']  = {'location': 'IOB12_D13P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u2sin']  = {'location': 'IOB12_D12N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u2sip']  = {'location': 'IOB12_D12P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u2don']  = {'location': 'IOB12_D11N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u2dop']  = {'location': 'IOB12_D11P', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u2son']  = {'location': 'IOB12_D10N', 'type': 'LVCMOS_2.5V_2mA'}
        self.pads['u2sop']  = {'location': 'IOB12_D10P', 'type': 'LVCMOS_2.5V_2mA'}

        # Interfaces definition.
        self.interfaces['led9']  = 'USER_D0'
        self.interfaces['led10'] = 'USER_D1'
        self.interfaces['led11'] = 'USER_D2'
        self.interfaces['led12'] = 'USER_D3'
        self.interfaces['led13'] = 'USER_D4'
        self.interfaces['led14'] = 'USER_D5'
        self.interfaces['led15'] = 'USER_D6'
        self.interfaces['led16'] = 'USER_D7'
        self.interfaces['led17'] = 'USER_CS_N'
        self.interfaces['led18'] = 'USER_WE_N'
        self.interfaces['led19'] = 'USER_DATA_OE'

##                                                                                                ##
## End of file                                                                                    ##
##                                                                                                ##
